/* hardware functions 
 * ver 1.0  
 * ver 1.1x   connectors signal working   
 * ver 1.20   added serialnr read
 * ver 1.22   defined cs lines to inactive in safe settings
 * ver 1.30   added CAL puls function   
 * ver 1.31   added CAL line lvl  function 
 * ver 1.32  added bias2dac voltage  and dac2bias  
 * ver 1.33  removed bias2dac voltage  and dac2bias
 *
 * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015
 */

#include "mbed.h"
#include "S_SCTRL_SM1_PinDef.h"
#include "S_SCTRL_SM1_hwfunct.h"


#define HW_LIB_SRC_VERSION "1.33"

#define MAXLIBVERCHAR 100  // max char for lib version 

void assignports(HWlines  *hwlines ){

/// devices 
// SPI BI pins 
hwlines->msio[0] = new DigitalInOut(ADC_STIO);
hwlines->sclk[0] = new DigitalOut(SCLK);
hwlines->direction[0] = new DigitalOut(DIRECTION);
hwlines->stio_mo[0] = new DigitalOut(STIO_MO);
hwlines->csb1[0] = new DigitalOut(ADC1_CSN);
hwlines->csb2[0] = new DigitalOut(ADC2_CSN);



// SPI pins
hwlines->mosi[0] = new DigitalOut(MOSI); 
hwlines->miso[0] = new DigitalIn(MISO); 

hwlines->t_cs[0] = new DigitalOut(TEMP_CSN);
hwlines->tc_cs1[0] = new DigitalOut(TEMP_CABLE_CSN1);
hwlines->tc_cs2[0] = new DigitalOut(TEMP_CABLE_CSN2);
hwlines->dac_cs[0] = new DigitalOut(DAC_DCEN);
hwlines->dac_rst[0] = new DigitalOut(DAC_RSTN);




// devices 
// SPI BI pins 
hwlines->msio[1] = new DigitalInOut(ADC_2_STIO);
hwlines->sclk[1] = new DigitalOut(SCLK_2);
hwlines->direction[1] = new DigitalOut(DIRECTION2);
hwlines->stio_mo[1] = new DigitalOut(STIO2_MO);
hwlines->csb1[1] = new DigitalOut(ADC1_2_CSN);
hwlines->csb2[1] = new DigitalOut(ADC2_2_CSN);

// SPI pins
hwlines->mosi[1] = new DigitalOut(MOSI_2); 
hwlines->miso[1] = new DigitalIn(MISO_2); 

hwlines->t_cs[1] = new DigitalOut(TEMP_2_CSN);
hwlines->tc_cs1[1] = new DigitalOut(TEMP_2_CABLE_CSN1);
hwlines->tc_cs2[1] = new DigitalOut(TEMP_2_CABLE_CSN2);
hwlines->dac_cs[1] = new DigitalOut(DAC_2_DCEN);
hwlines->dac_rst[1] = new DigitalOut(DAC_2_RSTN);


//cal 
hwlines->cal13[0] = new DigitalOut(CAL_TRIG_1AND3);
hwlines->cal24[0] = new DigitalOut(CAL_TRIG_2AND4);
hwlines->calint[0] = new DigitalOut(SEL_CAL_INT);
hwlines->cal13[1] = new DigitalOut(CAL_TRIG_1AND3);
hwlines->cal24[1] = new DigitalOut(CAL_TRIG_2AND4);
hwlines->calint[1] = new DigitalOut(SEL_2_CAL_INT);

hwlines->calext = new DigitalOut(SEL_CAL_EXT);
hwlines->calgenext = new DigitalOut(GEN_EXT_CAL);

hwlines->ledred = new DigitalOut(LEDRED);
hwlines->ledgreen = new DigitalOut(LEDGREEN);

hwlines->ain[0] = new AnalogIn(ADC1);
hwlines->ain[1] = new AnalogIn(ADC2);

hwlines->snr[0] = new DigitalIn(AD0);
hwlines->snr[1] = new DigitalIn(AD1);
hwlines->snr[2] = new DigitalIn(AD2);
hwlines->snr[3] = new DigitalIn(AD3);
hwlines->snr[4] = new DigitalIn(AD4);

}



// select intern or extern cal   0 = intern, 1 is extern 
void setcalsource( int external, HWlines hwl) {
    *(hwl.calext)=0;    
    *(hwl.calint[0])=0; *(hwl.calint[1])=0;  //disable all 
    if ( external==1 ) {*(hwl.calext)=1; }
    else {*(hwl.calint[0])=1; *(hwl.calint[1])=1;  }

    
}

// set the default , save values 
void setdefault(HWlines hwl ) {
        for ( int i=0;i<2;i++){  // i == connector
            hwl.msio[i]->input();
            *(hwl.direction[i])=RDIR_IN;
            *(hwl.stio_mo[i])=LDIR_IN;
            hwl.sclk[i]->write(0);
            hwl.csb1[i]->write(0);
            hwl.csb2[i]->write(0);
            hwl.t_cs[i]->write(0);
            hwl.tc_cs1[i]->write(0);
            hwl.tc_cs2[i]->write(0);
            hwl.dac_cs[i]->write(0);
            hwl.dac_rst[i]->write(0);                                               
        }
        hwl.cal13[0]->write(CAL_DEACTIVE); 
        hwl.cal24[0]->write(CAL_DEACTIVE);  
        setcalsource(0,hwl); //intern
}


void set_bi_spi_mo(int masterout, DigitalInOut* msio, DigitalOut* ldir, DigitalOut* rdir){
 // default directions 
    if( masterout == 0 ) { // master in
            msio->input();
            rdir->write(RDIR_IN);            
            ldir->write(LDIR_IN);

    }
    else { //master out
        
        ldir->write(LDIR_OUT);
        msio->output();
        rdir->write(RDIR_OUT);
    }
}



char libversion[MAXLIBVERCHAR]={'e','m','p','t','y','\0'};


void set_cal_line(HWlines  hwl, int calline ,int level ){
   int lvl;
   if( level ==1) lvl=CAL_ACTIVE; else lvl=CAL_DEACTIVE;
   if( calline == 0) {
        hwl.cal13[0]->write(lvl); //index can be hard coded as it are the same lines) 
        hwl.cal24[0]->write(lvl);  
    }
    if( calline == 1) {
       hwl.cal13[0]->write(lvl); //index can be hard coded as it are the same lines)         
    }
    if( calline == 2) {        
        hwl.cal24[0]->write(lvl);   
    }
    
}

void toggle_cal(HWlines  hwl, int calline){
    if( calline == 0) {
        hwl.cal13[0]->write(CAL_ACTIVE); //index can be hard coded as it are the same lines) 
        hwl.cal24[0]->write(CAL_ACTIVE);  
    }
    if( calline == 1) {
        hwl.cal13[0]->write(CAL_ACTIVE); //index can be hard coded as it are the same lines)         
    }
    if( calline == 2) {        
        hwl.cal24[0]->write(CAL_ACTIVE);  
    }
    // else we don't do nothing 
    wait_us(10);
    hwl.cal13[0]->write(CAL_DEACTIVE); 
    hwl.cal24[0]->write(CAL_DEACTIVE);  
    
}     


char*   hwfunct_lib_version(){
    sprintf(libversion,"hw lib versions  src : %s header:  %s pindef %s,date:%s %s \n\r",
            HW_LIB_SRC_VERSION,HW_LIB_HDR_VERSION , PINDEF_VER, __DATE__,__TIME__);
    return libversion;
    
}

int get_serialnr(HWlines  *hwlines ){
    int snr=0;
    for( int bitnr=4 ; bitnr  >= 0  ;bitnr--){
        snr=snr<<1;
        snr|=hwlines->snr[bitnr]->read();
    }
    return snr;
}

