#ifndef DEIMOS32_H
#define DEIMOS32_H

/*
 * class related to DEIMOS specific operationt
     
 * v0.10  initial development 
 * v1.00  added  class, only setHV 
 * v1.04  forget to assign DAC channel corrected. 
  *
 * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015
*/ 


#include "AD5384.h"
#define DEIMOSHDRVER 1.06

// BIAS channel nr in the layout so have to subtract 1 to control the channel
#define  DACBIASCH  39 
// CAL 1  DAC CH
#define  DACCAL1CH  33
#define  DACCAL2CH  34
#define  DACCAL3CH  35
#define  DACCAL4CH  36

#define HVmin 60   
#define DVmax 4.5  // max volt out of the DAC 
class Deimos32  {
    float HVnom;
    u32 serialnr;
    u8 con;
    AD5384* dac; // 
    public:
        // init
        // volt  the max value of the HV source 
        // connectornr : the connector the DEIMOS is connected to
        // dacdev to witch DAC device the channel is connected 
        Deimos32( float volt, u8 connectornr,AD5384* dacdev  ){        
            serialnr=2000; con=connectornr;// real connector nr 
            HVnom=volt; 
            dac= dacdev;        
        }
        
        
        float   setHV(float volt ,u16&  dacvalue ) {
            if (HVnom < HVmin ) return -22;
            float dv=HVnom-volt;
            if (dv > DVmax  || dv < 0  ) return -23;
            dacvalue=dac->set_volt(DACBIASCH , dv);
            return 0;
        } 
        float getHv(){
            if (HVnom < HVmin ) return -22;
            float act_hv=HVnom - dac->get_volt(DACBIASCH);
            return act_hv;
        }
        float getHvNom(){return HVnom;} 
    };
#endif 