#include "mbed.h"
#include "mbed.h"
#include "SWSPI.h"
#include "SWSPI_BI.h"
#include "S25FL216K.h"
#include "AD5384.h"
#include "AD9249.h"
#include "adt7320.h"
#include "S_SCTRL_SM1_PinDef.h" 
#include "S_SCTRL_SM1_hwfunct.h" 

#define VERSION "1.41"

#define DEBUGPF(x) printf((x));
// pin function         pin id 
// SPI 1 


S25FL216K flash(F_MOSI, F_MISO, F_SCLK,F_CS); 
Serial pc(USBTX,USBRX);


char c='.';
void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt  
    c = pc.getc();
    printf("%c:",c );    
 }


//++++++++++++++++++++++
  int main()   {   
    bool testADC=false;
    bool testDAC=true;  
    bool testTEMP=false;//true;
       pc.attach(&callback);// handles the input on the RS232 interface  
    HWlines  hwl ;
    assignports( &hwl );
    setdefault(hwl );
    
    SWSPI spi(hwl.mosi[0],hwl.miso[0],hwl.sclk[0]); // mosi, miso, sclk
    SWSPI spi2(hwl.mosi[1],hwl.miso[1],hwl.sclk[1]); // mosi, miso, sclk
    SWSPI_BI spi_adc(hwl.msio[0],hwl.direction[0],hwl.stio_mo[0] ,hwl.sclk[0]); // msio, dir , sclk 
    SWSPI_BI spi_adc2(hwl.msio[1],hwl.direction[1],hwl.stio_mo[1],hwl.sclk[1]); // msio, dir , sclk 
  
    
      AD9249 adc[2][2]={AD9249( &spi_adc,hwl.csb1[0]), AD9249( &spi_adc,hwl.csb2[0]),
                        AD9249( &spi_adc2,hwl.csb1[1]),  AD9249  ( &spi_adc2,hwl.csb2[1])};
     
      AD5384 dac[2][1]={AD5384(&spi,hwl.dac_cs[0],hwl.dac_rst[0]), AD5384(&spi2,hwl.dac_cs[1],hwl.dac_rst[1]) };
      adt7320 temp[2][3]= { adt7320(&spi, hwl.t_cs[0]),adt7320(&spi, hwl.tc_cs1[0]),adt7320(&spi, hwl.tc_cs2[0]),
                            adt7320(&spi2, hwl.t_cs[1]),adt7320(&spi2, hwl.tc_cs1[1]),adt7320(&spi2, hwl.tc_cs2[1]) };
      //float humi;
      
      
      
      DEBUGPF("start");
      printf(" version  %s compiled %s %s \n\r" , VERSION , __DATE__, __TIME__ );
      printf(" boardserialnr %d \n\r", get_serialnr(&hwl));
      u8 consel1=0;
      u8 consel2=1;
      u8 conls=0, conle=0;  // connector select loop start , connector select loop stop
      // cc == connector counter
            if( consel1==1 && consel2== 0) { conls=0; conle=1;} // only first connector connected 
      else  if( consel1==0 && consel2== 1) { conls=1; conle=2;} // only second  connector connected 
      else  if( consel1==1 && consel2== 1) { conls=0; conle=2;} // 
      else                                 { conls=0; conle=0;} // no connectors connected 
      unsigned char id, grade ;
      
      
     /* for (u8 cc= conls; cc < conle ; cc++) {
        adc[cc][0].getDevInfo(id,grade);printf(" %d %d ",id, grade);
        adc[cc][1].getDevInfo(id,grade);printf(" %d %d ",id, grade);
        
      }*/
      // init parts
      for (u8 cc= conls; cc < conle ; cc++) {
          if( testDAC) { dac[cc][0].init1();
        }
      }
      
      u32 count =0;
      while(1)   {
        for (u8 cc= conls; cc < conle ; cc++) {
            u16 rb,rb2; 
            if( testADC) {     
                adc[cc][0].getDevId(id);
                adc[cc][0].getGrade(grade);
                //adc[cc][0].getDevInfo(id,grade,rb);
                printf("id %02X grade %02X",id, grade );
                printf("\n\r");
                adc[cc][0].setPattern1(0x1235);
                adc[cc][0].setPattern2(0xA5FF);
                adc[cc][0].readPattern1(rb);       
                adc[cc][0].readPattern2(rb2);
                printf("pattern1 %04X  pattern2 %04X",rb,rb2);
                printf("\n\r");
             }
            if( testDAC ) {   
                u16 dataread,dr2;
                u8 ch = count%39;
                
                float value=2.742; // count%16383;
                u16 gain=(count)%16383;//0x1235; 
               //dataread=dac[cc].set_volt(ch,value);
                dr2=dac[cc][0].set_dac(ch,gain);
                wait(0.001);
                dataread=dac[cc][0].get_dac(ch);
                printf("ch %02X dac %04X ",ch,dr2);  
                printf("rb %04X ",dataread);
                dataread=dac[cc][0].get_offset(ch);
                dr2=dac[cc][0].get_gain(ch);
                printf("gain %04X ",dr2);  
                printf("offset %04X",dataread);
                dataread=dac[cc][0].get_ctrl(); 
                printf(" cntrl %04X\n\r",dataread);
            }
            if( testTEMP) {
                u16 dataread ;
                u8 id;
                id=temp[cc][0].getId();
                dataread=temp[cc][0].get_TcritSP();
                printf( "temp chip ID %02X , Tcrit %04X \n\r", id, dataread);
            }
        }
        wait(.25);count++;
        /*
        flash.write(0,&c,1);
        
        humi=ain1.read();
        printf("humid %f \n ",humi);   
        */
      }
  }
 
 