#include "mbed.h"
#include "I2C.h" 
#define TARGET TARGET_KL05Z
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif



#include "I2CInterface.h"
#include "MBEDI2CInterface.h" 
#include "MCP4728setaddr.h"

MBEDI2CInterface mbedi2c( SDA, SCL); 

MBEDI2CInterface* mbedi2cp=  &mbedi2c ;

I2CInterface* i2cdev= mbedi2cp;


DigitalOut LDAC(PTA6);
DigitalOut CntPin(PTA7);
 

I2CInterface* i2cif;


int main(void){
  printf("\n\rMCP4728 set address program date : %s  time :%s\n\r",__DATE__,__TIME__); 

  LDAC=1;
  char oldaddr, eeaddr=33, regaddr=34, newaddr= 2;
  int newaddrint;
  MPC4728_address_set mpc4728(PTB0,&LDAC,i2cdev, &CntPin, true);
  int i2cresult =mpc4728.readaddress(oldaddr, eeaddr, regaddr);
  if ( i2cresult ) {
    printf("failed to read current address error code: %d , scl cnt = %d  \n", i2cresult,mpc4728.getsclcnt() );
  }
  else { 
    printf( " current address = %d 0X%x ,eeaddr %d , regaddr %d  sclcnt= %d  give new address :  ", (int) oldaddr,(int) oldaddr,(int) eeaddr, (int)regaddr, mpc4728.getsclcnt());  
    scanf( "%d",&newaddrint);
    printf("new addr %d \n\r", newaddrint );
    if ( newaddrint >= 0 && newaddrint <= 8 ) {
        newaddr= (char) newaddrint;
        i2cresult=mpc4728.setaddress(eeaddr,newaddr);
        if ( i2cresult ) printf("failed to set address to %d error : %d , sclcnt= %d  \n",newaddr, i2cresult,mpc4728.getsclcnt());
        else {
             printf("set new  address \n");
            i2cresult =mpc4728.readaddress(oldaddr, eeaddr, regaddr);
            if ( i2cresult ) printf("failed to read (new)  address error : %d  \n", i2cresult);
            else     printf( "new address = %d ,eeaddr %d , regaddr %d  sclcnt= %d  \n\r", (int) oldaddr,(int) eeaddr, (int)regaddr, mpc4728.getsclcnt());  printf( " new address = %d \n", (int) oldaddr);
        }
    }    
    else {
        printf( " new address %d is not valid reset the up to restart the program \n", (int)newaddr );
    }
  }
  printf("restart !!!! \n\r");
  while (1);  
  //return 0; // never reach this       
};

