


class I2CInterface;
//class DigitalOut;
//class InterruptIn;

class MPC4728_address_set{
    I2CInterface *i2cd;
    DigitalOut *LDAC;
    DigitalOut *Cntout;
    InterruptIn cntin;
    int sclcnt;
    unsigned char oldaddress;
 void count_down( );
 int ldac1;
 int ldac0;
 
public:
 /*
    sclcntpin  : the pin physically connected to the I2C SCL line that counts the clock pulses ( via interrupt) 
    LDACpin pointer to the pin that change polarity after x SCL clock pulses to set the address (see data sheet) 
    i2cdevice : pointer to the I2C interface 
    Cntoutpin :  this is to debug the count down interrupt.  This toggles everty time the cnt down interrupt is called ( no function for the MPC4728)
    ldac_invert :  if this active the LDAC line is set from  1 to 0 
 */    
 MPC4728_address_set(PinName sclcntpin, DigitalOut *LDACpin, I2CInterface* i2cdevice, DigitalOut *Cntoutpin , bool ldac_invert=false  );
 int getsclcnt( ){return sclcnt;}
  int readaddress(char& address, char& eepromaddr , char& regaddr );

  int setaddress(char currentaddress, char newaddress );

  void start_scl_cnt(int cnts) ;

};//endclass 
