#include "mbed.h"


#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#include "I2C.h"
#include "I2CInterface.h" 
#include "MBEDI2CInterface.h" 

#include "dev_interface_def.h"

#include "mcp23009.h"

MBEDI2CInterface mbedi2c( SDA, SCL); 
MBEDI2CInterface* mbedi2cp=  &mbedi2c ;
I2CInterface* i2cdev= mbedi2cp;


Serial pc(USBTX, USBRX);


int main(void)
{
    
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    MCP23009   gpio(i2cdev, 0);    
    
    printf("mcp23009 test program %s %s \n\r",__DATE__,__TIME__);
    int pincnt=0;
    int pinv;
    if( gpio.set_as_output(0,0)) {printf("(I2C) error setting pin 0 as ouput\n\r");}
    if( gpio.set_as_input(1,0))  {printf("(I2C) error setting pin 1 as input\n\r");}
    if( gpio.set_as_output(2,0)) {printf("(I2C) error setting pin 2 as ouput\n\r");}
    if( gpio.set_as_output(3,1)) {printf("(I2C) error setting pin 3 as ouput\n\r");}
    if( gpio.set_as_output(4,1)) {printf("(I2C) error setting pin 4 as ouput\n\r");}
    if( gpio.set_as_output(5,1)) {printf("(I2C) error setting pin 5 as ouput\n\r");}
    if( gpio.set_as_output(6,0)) {printf("(I2C) error setting pin 6 as ouput\n\r");}
    if( gpio.set_as_output(7,1)) {printf("(I2C) error setting pin 7 as ouput\n\r");}
    int value;
    while (true) {
        value = gpio.status(pincnt);    
        printf("pinnr : current status  : %d\n\r",value);
        value = gpio.status(8); 
        printf("all pins: current status  : 0x%02X\n\r",value);
        value = gpio.outp_status(8); 
        printf("all pins: current outputstatus  : 0x%02X\n\r",value);
        printf("give  new value for pinnr:%d ",pincnt);
        scanf("%d",&pinv); printf("\n\r");
        
        gpio.set(pincnt,pinv);     
        pincnt++;
       
        wait(0.1f);
        if ( pincnt  > 7 ) pincnt=0;
    }
}
