/** example program for the use of the AT30TSE7xx class 
 *
 *  V 0.4  : tested on the KL25z 
 * tested eeprom read/ write  full page / single byte  
 * temperature read 12 bit resolution
 * fix chip configuration.
 * (C) Wim Beaumont Universiteit Antwerpen 2017 
 */ 

#define AT30TSE753EXAMPLEVER "0.63"

#include "mbed.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE0;
  PinName const SCL = PTE1;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif


#include "I2C.h"
#include "I2CInterface.h" 
#include "MBEDI2CInterface.h"  
#include "dev_interface_def.h"
#include "AT30TSE75x.h"


MBEDI2CInterface mbedi2c( SDA, SCL); 
MBEDI2CInterface* mbedi2cp=  &mbedi2c ;
I2CInterface* i2cdev= mbedi2cp;

DigitalInOut  CntrA1(PTD1, PIN_INPUT ,  PullNone,0);
DigitalInOut  CntrA2(PTD3, PIN_INPUT ,  PullNone,0);
Serial pc(USBTX, USBRX);

void print_buf_hex( char *data, int length){
    int nr;
    char *ptr=data;
    for ( int lc=0; lc < length ; lc++){
        nr= (int) *(ptr++);
        printf( "%02x ",nr);
    }
    printf("\n\r");
}        


int main(void) {  //432109876543210 \0   
   char str1[16] = "SOLTEMPERAT0231";
   char str2[16] ;
   char str4[16] ;
   char str3[16]=  "20170117...0230" ;
   char resp[3];
   // get the version of getVersion 
   getVersion gv;
   int addr=0;
   int i2cerr;
   int cnt=0;
   
   printf("AT30TSE752  example program version %s, compile date %s time %s\n\r",AT30TSE753EXAMPLEVER,__DATE__,__TIME__);
   printf("getVersion :%s\n\r ",gv.getversioninfo());
   printf("%s\n\r",str1);
   
   printf("give new addr "); scanf("%d", &addr);
   if ( addr < 0 || addr > 15) addr=0;
   fflush(stdin);
   
   AT30TSE75x tid( i2cdev ,addr); 
   printf ( "AT30SE75x version :%s\n\r ",tid.getversioninfo());
   printf( "Taddr %x , Eaddr %x  subaddr %d\n\r ", tid.getTaddr(),tid.getEaddr(), addr);
   
 
   
   i2cerr=tid.set_config();
   if( i2cerr) printf("config not set  %d \n\r", i2cerr);
   int configrd= tid.read_config( 0, &i2cerr);
   printf( " config %x  I2cerr %d \n\r", configrd,i2cerr ); 
   printf("write to eprom ?"); scanf("%s",resp);
   int pagenr=0;
   int sernr;
   if(resp[0] == 'y'){  
    i2cerr= tid.write_eeprompage(str1, 16, 0, (uint8_t) pagenr++);
    if(i2cerr) printf("eeprom write error %d\n\r",i2cerr);
    printf("give serial nr to write "); scanf("%d",&sernr);
    sprintf(str2,"%015d",sernr);
    i2cerr= tid.write_eeprompage(str2, 16, 0, (uint8_t) pagenr++);
    wait_ms(400); // give some time to write 
    i2cerr= tid.write_eeprompage(str3, 16, 0, (uint8_t) pagenr++);
    float tempcor, tempref;
    printf("\n\rgive temperature correction"); scanf("%f",&tempcor);
    printf("\n\rgive ref temperature "); scanf("%f",&tempref);
    sprintf(str4,"%8.4f %7.4f",tempcor,tempref);
    i2cerr= tid.write_eeprompage(str4, 16, 0, (uint8_t) pagenr++);
   }
   wait_ms(400); // give some time to write 
   //strcpy(str1,"newstr1");strcp(str2,"newstr2");strcp(str3,"newstr3");
   bool fix=true;
   while(1) {
    pagenr=0;
    i2cerr=tid.read_eeprompage(str1, 16, 0, (uint8_t) pagenr++);
    if(i2cerr) printf("eeprom read error %d \n\r",i2cerr);
    
    i2cerr=tid.read_eeprompage(str2, 16, 0, (uint8_t) pagenr++);
    if(i2cerr) printf("eeprom read error %d \n\r",i2cerr);
    i2cerr=tid.read_eeprompage(str3, 16, 0, (uint8_t) pagenr++);
    if(i2cerr) printf("eeprom read error %d \n\r",i2cerr);
    i2cerr=tid.read_eeprompage(str4, 16, 0, (uint8_t) pagenr);
    if(i2cerr) printf("eeprom read error %d \n\r",i2cerr);
    str1[15]='\0';str2[15]='\0';str3[15]='\0';str4[15]='\0'; //make sure it ends 
    printf("eeprom content page %d :\n\r %s  %s  %s %s \n\r",pagenr,str1 ,str2 ,str3 ,str4);
    //print_buf_hex( str1,16);
    if ( fix) {
        printf("protect eeprom ?") ;scanf("%s",resp);
        if(resp[0] == 'y'){  
            printf("\n\rconnect A0 to 7 V  y, t return when done \n\r");scanf("%s",resp);
            CntrA1.output(); CntrA1.write(0);
            CntrA2.output(); CntrA2.write(0);
            i2cerr=tid.get_eeprom_protec();
            if ( i2cerr ) { printf("ee-prom write protected \n\r");}
            else { printf("ee-prom NOT write protected \n\r"); }
            i2cerr=tid.protect_eeprom();
            if(i2cerr) printf("eeprom  protect failed %d \n\r", i2cerr);
            i2cerr=tid.get_eeprom_protec();
            wait_ms(100);
            if ( i2cerr ) { printf("ee-prom write protected \n\r");}
            else { printf("ee-prom NOT write protected \n\r"); }
            CntrA1.input(); CntrA1.mode(PullNone);
            CntrA2.input(); CntrA2.mode(PullNone);
            printf("disconnect A0 from 7 V  y, t return when done \n\r");scanf("%s",resp);
        }
        // fix=false;
        printf("unprotect eeprom ?") ;scanf("%s",resp);
        if(resp[0] == 'y'){  
            printf("\n\rconnect A0 to 7 V  y, t return when done \n\r");scanf("%s",resp);
            CntrA1.output(); CntrA1.write(0);
            CntrA2.output(); CntrA2.write(0);
            i2cerr=tid.get_eeprom_protec();
            if ( i2cerr ) { printf("ee-prom write protected \n\r");}
            else { printf("ee-prom NOT write protected \n\r"); }
            CntrA1.output(); CntrA1.write(1);
            wait_ms(100);
            i2cerr=tid.unprotect_eeprom();
            if(i2cerr) printf("eeprom  protect failed %d \n\r", i2cerr);
            CntrA1.output(); CntrA1.write(0);
            wait_ms(100);
            i2cerr=tid.get_eeprom_protec();
            if ( i2cerr ) { printf("ee-prom write protected \n\r");}
            else { printf("ee-prom NOT write protected \n\r"); }
            CntrA1.input(); CntrA1.mode(PullNone);
            CntrA2.input(); CntrA2.mode(PullNone);
            printf("disconnect A0 from 7 V  y, t return when done \n\r");scanf("%s",resp);
        }
        
    }
    char singlechar;
    i2cerr=tid.read_eeprombyte(singlechar, 3, (uint8_t) pagenr); 
    if(i2cerr) printf("eeprom read error %d \n\r",i2cerr);
    printf("third char is : %c\n\r",singlechar);
    wait_ms(1000);    
    float Tmp= tid.get_temperature(&i2cerr);      
    printf ("%d:Temp = %f I2cerr %d \n\r",cnt++, Tmp, i2cerr);
   

  }
  
    
    // never reach this   
    return 1;
}   
