/************************************/
/***** PicoBorg Reverse Library *****/
/************************************/

// Includes
#include "PicoBorgReverse.h"        // The PicoBorg Reverse library constants


bool PicoBorgReverse::checkId(void) 
{
    i2c_write(PBR_COMMAND_GET_ID);
    char readBuf[PBR_I2C_MAX_LEN]  = {0};
    int readStatus = i2c_read(readBuf, PBR_I2C_MAX_LEN);
    return readBuf[1] == PBR_I2C_ID_PICOBORG_REV;
}


void PicoBorgReverse::resetEpo(void)
{
    i2c_write(PBR_COMMAND_RESET_EPO);
}

bool PicoBorgReverse::getEpo(void) {
    i2c_write(PBR_COMMAND_GET_EPO);

    char readBuf[PBR_I2C_MAX_LEN]  = {0};
    int readStatus = i2c_read(readBuf, PBR_I2C_MAX_LEN);

    return readBuf[1] == PBR_COMMAND_VALUE_ON;
}

// Sets the system to ignore or use the EPO latch, set to false if you have an EPO switch, true if you do not
void PicoBorgReverse::setEpoIgnore(bool state) {
    i2c_write(PBR_COMMAND_SET_EPO_IGNORE,  state ? PBR_COMMAND_VALUE_ON : PBR_COMMAND_VALUE_OFF);
}

// Reads the system EPO ignore state, False for using the EPO latch, True for ignoring the EPO latch
bool PicoBorgReverse::getEpoIgnore(void) {

    i2c_write(PBR_COMMAND_GET_EPO_IGNORE);

    char readBuf[PBR_I2C_MAX_LEN]  = {0};
    int readStatus = i2c_read(readBuf, PBR_I2C_MAX_LEN);

    return readBuf[1] == PBR_COMMAND_VALUE_ON;
    
}


bool PicoBorgReverse::getCommsFailsafe(void)
{
    i2c_write(PBR_COMMAND_GET_FAILSAFE);

    char readBuf[PBR_I2C_MAX_LEN]  = {0};
    int readStatus = i2c_read(readBuf, PBR_I2C_MAX_LEN);

    return readBuf[1] == PBR_COMMAND_VALUE_ON;
}

void PicoBorgReverse::setCommsFailsafe(bool state)
{
   i2c_write(PBR_COMMAND_SET_FAILSAFE,  state ? PBR_COMMAND_VALUE_ON : PBR_COMMAND_VALUE_OFF);
}

bool PicoBorgReverse::getDriveFault(void) {
    i2c_write(PBR_COMMAND_GET_DRIVE_FAULT);

    char readBuf[PBR_I2C_MAX_LEN]  = {0};
    int readStatus = i2c_read(readBuf, PBR_I2C_MAX_LEN);

    return readBuf[1] == PBR_COMMAND_VALUE_ON;
}



// Motor functions

void PicoBorgReverse::setMotor1(int power)
{
    char cmd = power < 0 ? PBR_COMMAND_SET_B_REV : PBR_COMMAND_SET_B_FWD;
    power = power > PBR_PWM_MAX ? PBR_PWM_MAX : abs(power);
    i2c_write(cmd, (char) power);
}

void PicoBorgReverse::setMotor2(int power)
{
    char cmd = power < 0 ? PBR_COMMAND_SET_A_REV : PBR_COMMAND_SET_A_FWD;
    power = power > PBR_PWM_MAX ? PBR_PWM_MAX : abs(power);
    i2c_write(cmd, (char) power);
}


void PicoBorgReverse::setLed(bool state) {    
    i2c_write(PBR_COMMAND_SET_LED,  state ? PBR_COMMAND_VALUE_ON : PBR_COMMAND_VALUE_OFF);
}


