#include "mbed.h"
#include "Blinker.h" // !LIBRARY!
// In this program is made turning on white, yellow and red led according to potentiometer output.
// In case of switching the switch to ON position, red LED turns ON and blue led blinks 5 times. !HARDWARE INTERRUPT!
// After that, red LED stays ON, while white and yellow can be switched ON or OFF according to potentiometer output.
// When switch goes back to OFF position, blue LED blinks for 2 times and the program goes back to standard mode.
// Internal green LED blinks every 0.2 seconds to indicate that the program is running. !TICKER!

InterruptIn button(D6,PullUp);  // Interrupt - switch
AnalogIn Ain(A1);               // Potentiometer input
DigitalOut internalled(LED1);   // Internal green LED
DigitalOut whiteled(D2);
DigitalOut yellowled(D3);
DigitalOut redled(D4);
BusInOut led(D2,D3,D4);     // Bus with four LEDs
Blinker blueled(D5);        // !CLASS! for blinking led in case of event

Ticker flipper;
void toggle(void);      // function protype - 1st interrupt !FUNCTION!
void toggle2(void);     // function protype - 2nd interrupt
void flip()             // flip function
{
    internalled = !internalled; // Internal LED changes its state
}
bool emergency = 0;     // Starting position of emergency "button"

int main()              // Glavni program
{
    internalled = 0;
    flipper.attach(&flip, 0.2); // the address of the ticker function to be attached and the interval (sec).
    
    button.fall(&toggle);   // attach the address of the toggle function to the falling edge
    button.rise(&toggle2);  // attach the address of the toggle function to the rising edge
        
    led.output();
    float ADCdata;          // float for output from potentiometer
    
    while (1)               // loop for raising and falling temperature (potentiometer)
    {
        ADCdata = Ain;      // Assining analog input value to float ADCdata
        if (emergency==0)   // If emergency "button" is in off position
        {                   // Regular events for changing temperature of transformer
            if(ADCdata<=0.3)// If potentiometer value is equal or less than 0.3
            {
                led = 0;    // All LEDs are off
            }
            if(ADCdata>0.3) // If potentiometer value is over 0.3
            {
                led = 0b0001;   // Switch on white (1st) LED - fans
            }
            if(ADCdata>0.6) // If potentiometer value is over 0.6
            {
                led = 0b0011;   // Switch on also yellow (2nd) LED - alarm
            }
            if(ADCdata>0.9) // If potentiometer value is over 0.9
            {
                led = 0b0111;   // Switch on also red (3rd) LED - trip
            }
            wait (0.2);
        }
        else    // If an emergency button is in ON position (Oil Level Indicator sent signal "trip")
        {
            if(ADCdata<=0.3)    // If potentiometer value is equal or less than 0.3
            {
                led = 0b0100;   // Keep LEDs off except from red LED (trip)
            }
            if(ADCdata>0.3)     // If potentiometer value is over 0.3
            {
                led = 0b0101;   // Switch on white LED and keep red LED on
            }
            if(ADCdata>0.6)     // If potentiometer value is over 0.6
            {
                led = 0b0111;   // Switch on also yellow LED and keep red LED on. There is no need to make an "if" for over 0.9, because red LED is already ON.
            }            
        }
    }
}

void toggle()   // First interrupt
{
    emergency = 1;      // Emergency button ON
    redled=1;           // Switch on red LED
    blueled.blink(5);   // Blinking blue LED for 5 times
    wait (1);           // Hold for 1 second
}                       // Interrupt is over, but the emergency button is still pushed. Red LED stays ON.
void toggle2()          // Second interrupt
{
    emergency = 0;      // Emergency button OFF
    blueled.blink(2);   // Blinking blue LED for 2 times
}