#include "mbed.h"

/*LPF cut off frequency 600Hz(3rd Order with 20kHz sampling frequency)*/
AnalogIn Ain(p15);
AnalogOut Aout(p18);

float data_in,data_out;

Ticker s1_khz_tick;

__ASM int addi(int a, int b)
{
    ADDS R0, R1
    BX LR
}

__ASM int multi(int a, int b)
{
    MUL R0, R1
    BX LR
}

__ASM int move(int a, int b)
{
    MOV R0, R1
    BX LR
}

float LPF(float LPF_in)
{

    //------------------------------FIR ----------------------------------------------------
    float fda_coeff[16] = {0.00028360651120682420830293457569837301,
                           0.00822761997979659653879025427158921957,
                           0.009652502067820697279065811358123028185,
                           -0.020505027860776389725394608376518590376,
                           -0.055082214281865632399259880003228317946,
                           0.001759656378417649713608028605449362658,
                           0.187202210776797661750947554537560790777,
                           0.369320487034980882157242376706562936306,
                           0.369320487034980882157242376706562936306,
                           0.187202210776797661750947554537560790777,
                           0.001759656378417649713608028605449362658,
                           -0.055082214281865632399259880003228317946,
                           -0.020505027860776389725394608376518590376,
                           0.009652502067820697279065811358123028185,
                           0.00822761997979659653879025427158921957,
                           0.00028360651120682420830293457569837301
                          };

    static float LPF_out;                     //the return variable/outbput of filter
    static float x[12], y, z[12];

    for (int i = 10; i >= 0; i--) {
        x[i+1] = move(x[i+1], x[i]);
    }

    x[0] = move(x[0], LPF_in);

    for (int i = 0; i < 12; i++) {
        z[i] = multi(fda_coeff[i], x[i]);
    }

    for (int i = 0; i < 12; i++) {
        y = addi(z[i], y);
    }

    LPF_out = move(LPF_out, y);
    return LPF_out; //output filtered value
}

void s1khz_task(void)
{
    data_in = Ain - 0.5;   //Note the embed can only accept positive voltage inputs, it is necessary to add a small coupling and biasing circuit to
    //offset the signal midway of approx 1.65V.
    //A DC offset is a frequency component at 0 Hz. This can cause signal to wander.
    //Therefore the mean value of the signal is subtracted.This is also to normalize the signal to an average value of zero,
    //and allows the filter algorithm to perform DSP with no DC offset in the data.

    data_out = LPF(data_in);
    Aout = data_out + 0.5;
}

int main()
{
    s1_khz_tick.attach_us(&s1khz_task,1000); //1kHz sampling

    while(1);

}