#include "Timer_PID.h"

Timer_PID::Timer_PID(double kp, double ki, double kd) : PID_Control(kp, ki, kd)
{
    reset();
}

double Timer_PID::PID(double present, double target)
{
    interval = read_interval();
    return PID_Control::PID(present, target, interval);
}

double Timer_PID::read_interval()
{
    double time;
    time = timer.read();
    timer.reset();
    return time;
}

void Timer_PID::reset()
{
    PID_Control::reset();
    timer.reset();
    timer.start();
}
