#include "PID_Control.h"

PID_Control::PID_Control(double kp, double ki, double kd)
{
    set_PID(kp, ki, kd);
}

PID_Control::PID_Control(double ku, double pu)
{
	set_PID_ZN(ku, pu);
}

double PID_Control::PID(double present, double target, double interval)
{
    diff[0] = diff[1];
    diff[1] = target - present;
    integral += ((diff[0] + diff[1]) / 2.0) * interval;
    p = kp * diff[1];
    i = ki * integral;
    d = kd * (diff[0] - diff[1]) / interval;
    control = p + i + d;
    return control;
}

void PID_Control::reset()
{
    diff[0] = 0;
    diff[1] = 0.0;
    integral = 0.0;
    control = 0;
}

void PID_Control::set_PID(double kp, double ki, double kd)
{
    this->kp = kp;
    this->ki = ki;
    this->kd = kd;
    reset();
}

void PID_Control::set_PID_ZN(double ku, double pu)
{
	double ti,td;

	ti = 0.5 * pu;
	td = 0.125 * pu;

	this->kp = ku * 0.6;
	this->ki = kp / ti;
	this->kd = kp * td;
}
