#ifndef QEI_H_
#define QEI_H_

class QEI
{
public:
	QEI(int edge_per_revolution);
	virtual ~QEI(){};

	int read();
	void write(int set_count);
	void reset();

	double read_revolution();

	double read_total_revolution();
	void write_total_revolution(double set_total_revolution);
	void reset_total_revolution();

protected:
    virtual int _read() = 0;
    virtual void _write(int set_count) = 0;

private:
    void _add_count_to_total_revolution(int count);
    long _total_revolution, _total_revolution_decimal;
    int _edge_per_revolution;
};

#endif
