#include "QEI.h"

QEI::QEI(int edge_per_revolution)
	: _total_revolution(0), _total_revolution_decimal(0),
	  _edge_per_revolution(edge_per_revolution)
{}

int QEI::read()
{
	int count;
	count = _read();
	_add_count_to_total_revolution(count);
	return count;
}

void QEI::write(int set_count)
{
	//read();
	_write(set_count);
}

void QEI::reset()
{
	//read();
	_write(0);
}

double QEI::read_revolution()
{
	return (double)read() / (double)_edge_per_revolution;
}


double QEI::read_total_revolution()
{
	double revolution;
	//read();
	revolution = _total_revolution + (double)_total_revolution_decimal / (double)_edge_per_revolution;
	return revolution;
}

void QEI::write_total_revolution(double set_revolution)
{
	read();
	_total_revolution = (long)set_revolution;
	_total_revolution_decimal = (long)( (set_revolution - _total_revolution) * _edge_per_revolution );
}

void QEI::reset_total_revolution()
{
	read();
	_total_revolution = 0;
	_total_revolution_decimal = 0;
}

void QEI::_add_count_to_total_revolution(int count)
{
	_total_revolution_decimal += count;

	_total_revolution += _total_revolution_decimal / _edge_per_revolution;
	_total_revolution_decimal %= _edge_per_revolution;//2π進んだ分を帳消しにしとる?
}
