#include "Omni_2.h"

Omni_2::Omni_2(MD *md[NUM])
{
    _wheel[L] = new Wheel( md[L],  (3.0*M_PI)/4.0);
    _wheel[R] = new Wheel( md[R],  M_PI/4.0);

}


void Omni_2::move(double x, double y)
{
    double move_angle, move_radius;
    double duty[NUM];
    double max_duty, limit_duty = 1.0;
    
    move_angle = atan2(y, x);
    move_radius = sqrt( y * y + x * x );
    
    for(int i = 0; i < NUM; i++)
        duty[i] = _wheel[i]->wheel_speed(move_angle, move_radius);


	up_limit_balance(duty, NUM, max_duty);
	down_limit_balance(duty, NUM, limit_duty);
    
    for(int i = 0; i < NUM; i++){
        _wheel[i]->drive(duty[i]);
    }
}
