#ifndef MD_PID_H_
#define MD_PID_H_

#include <shared/MD/MD.h>
#include <shared/QEI/QEI.h>
#include <shared/Timer_PID/Timer_PID.h>

class MD_PID : public MD, public Timer_PID
{
public:
    MD_PID( MD *md, QEI *qei,
            double kp = 0, double ki = 0, double kd = 0,
			double max_speed = 0);
    virtual void drive(double target);
    virtual void brake(double target);
    virtual void free();
    void set_max_speed(double max_speed);
    double get_target();
    double get_duty();
    double get_speed();
    double get_revolution();
    
private:
    MD *md;
    QEI *qei;
    
    double read_speed();
    
    double target, duty, speed;
    double max_speed;
};

#endif
