#include "MD_PID.h"

MD_PID::MD_PID( MD *md, QEI *qei,
                double kp, double ki, double kd,
				double max_speed)
                : Timer_PID(kp, ki, kd)
{
    this->md = md;
    this->qei = qei;
    set_max_speed(max_speed);
}

void MD_PID::drive(double target)
{
    double present;

    this->target = max_speed * target;
    
    interval = read_interval();
    present = read_speed();
    
    if(target == 0){
        duty = 0;
        PID_Control::reset();
    }
    else{
    	duty += PID_Control::PID(present, this->target, interval);
    	//duty = target;//pid off
    }
    if( fabs(duty) > 1 )
        duty /= fabs(duty);
        
    md->drive(duty);
}

void MD_PID::brake(double target)
{
    
}

void MD_PID::free()
{
    
}

void MD_PID::set_max_speed(double max_speed)
{
	this->max_speed = max_speed;
}

double MD_PID::get_target()
{
	return target;
}

double MD_PID::get_duty()
{
	return duty;
}

double MD_PID::get_speed()
{
    return speed;
}

double MD_PID::get_revolution()
{
    return speed * interval;
}

double MD_PID::read_speed()
{
    double revolution_per_second, revolution;
    revolution = qei->read_revolution();
    qei->reset();
    revolution_per_second = revolution / interval;
    speed = revolution_per_second;
    return speed;
}
