#ifndef QEI_I2C_H_
#define QEI_I2C_H_

#include <mbed.h>
#include <shared/QEI/QEI.h>

class I2CQEI : public QEI
{
public:
    I2CQEI(int edge_per_revolution, I2C *i2c_bus, int i2c_address, int qei_id, int retries = 10);
    
    void set_retries(int);
    bool get_error();

protected:
    virtual int _read();
    virtual void _write(int set_count);

private:
    int16_t _i2c_read();
    bool _i2c_write(int value);

    I2C *_i2c_bus;
    int _i2c_address;
    int _qei_id;

    int _retries;
    bool _error;
};

#endif
