#include "I2CQEI.h"

I2CQEI::I2CQEI(int edge_per_revolution, I2C *i2c_bus, int i2c_address, int qei_id, int retries)
    : QEI(edge_per_revolution),
	  _i2c_bus(i2c_bus), _i2c_address(i2c_address), _qei_id(qei_id), _retries(retries), _error(true)
{
    reset();
}

void I2CQEI::set_retries(int retries)
{
	_retries = retries;
}

bool I2CQEI::get_error()
{
	return _error;
}

int I2CQEI::_read()
{
    int count;
    count = _i2c_read();
    return count;
}

void I2CQEI::_write(int set_count)
{
	_i2c_write(set_count);
}

int16_t I2CQEI::_i2c_read()
{
    char send_data[1];
    char recv_data[2];
    bool error = true;

    send_data[0] = _qei_id;

    for(int i = 0; i < _retries && error; i++) {
    	error = false;
    	error |= _i2c_bus->write(_i2c_address, send_data, 1, true);
    	error |= _i2c_bus->read(_i2c_address, recv_data, 2);
    }

    _error = error;
    if(!error){
    	return recv_data[0] | (recv_data[1] << 8);
    } else {
    	return 0;
    }
}

bool I2CQEI::_i2c_write(int value)
{
    char send_data[3];
    bool error = true;

    send_data[0] = _qei_id;
    send_data[1] = value & 0xFF;
    send_data[2] = (value >> 8) & 0xFF;

    for(int i = 0; i < _retries && error; i++) {
    	error = _i2c_bus->write(_i2c_address, send_data, 3);
    }

    _error = error;
    return error;
}
