#include "mbed.h"
#include <shared/I2CMD/I2CMD.h>
#include <shared/MD_PID/MD_PID.h>
#include <shared/I2CQEI/I2CQEI.h>
#include "B_Receive.h"
#include "B_bike.h"
#include "B_motor_oddmetry.h"

//Rに-1かけること

enum MD_KIND_40 {
    L,R, NUMBER
};
const int md_adder[2] = {0x10, 0x11};
const int qei_adder[2] = {0x20, 0x21};
const int adder1 = 0x0A;
const int add2 = 0x20;
const int epr = 512*4;

const double kp = 0.05,ki = 0.00,kd = 0.0;

const double maxspeed = 6.0;//無負荷最大回転数は15.0くらい。3.0,6.0が主流
double target[NUMBER] = {0.0, 0.0};
double duty[NUMBER] = {0.0, 0.0};
double speed[NUMBER] = {0.0, 0.0};
double revolution[NUMBER] = {0.0, 0.0};

char swdata = 0;

//弓動作-Arduino送信用
char logA = 0x10;

int flag = 0;
int flag2 = 0;

int field;//0 :blue,1 :red

DigitalOut myled(LED1);

DigitalIn red(D3);
DigitalIn blue(D2);


int main()
{

    B_Receive con(D1,D0);
    con.initialize_axis();

    Serial pc(USBTX,USBRX);
    pc.baud(9600);

    I2C i2c(D4,D5);
    MD *md1[NUMBER];
    MD *md2[NUMBER];

    red.mode(PullDown);
    blue.mode(PullDown);

    myled = 1;
    for(int i = 0; i < NUMBER; i++) {
        md1[i] = new I2CMD(&i2c, adder1, md_adder[i]);
    }

    QEI *qei[NUMBER];
    for(int i = 0; i < NUMBER; i++) {
        qei[i] = new I2CQEI(epr, &i2c, adder1, qei_adder[i]);
    }

    MD_PID *mdp[NUMBER];
    for(int i = 0; i < NUMBER; i++) {
        mdp[i] = new MD_PID(md1[i], qei[i], kp, ki, kd, maxspeed);
        md2[i] = mdp[i];
    }

    I2CMD bow(&i2c,adder1,0x12);

    B_bike *bike;
    bike = new B_bike(md2,1.0,1.0);

    B_motor_oddmetry *oddmetry[NUMBER];
    oddmetry[L]= new B_motor_oddmetry(md2[L],qei[L],1.0);
    oddmetry[R]= new B_motor_oddmetry(md2[R],qei[R],-1.0);

    char num = 0x00;
    char laser[2] = {0};

    myled = 0;

    wait(0.5);

    if(blue == 1 && red == 0) {
        field = 0;//Blue
        //pc.printf("blue\r\n");
    } else if(blue == 0 && red == 1) {
        field = 1;//red
        //pc.printf("red\r\n");
    } else {
        //pc.printf("else!!!!\r\n\r\n");
        while(1) {}
    }

    while(1) {

        myled = myled^1;

        i2c.write(add2,&num,1,true);//LAZER RANGE FINDER 読み込み
        i2c.read(add2,laser,2);
        long kyori = laser[1] << 8 | laser[0];
        pc.printf("kyori:%d mm\r\n",kyori*10);

        char data;//スイッチの処理
        if(con.get_error() == 0) {
            data = con.get_all_switch();
        } else {
            data = 0;
        }
        if(!(swdata & 0x01) && (data & 0x01)) {

            if(oddmetry[L]->odd_available() && oddmetry[R]->odd_available()) {//半自動(お止め鳥)
                //pc.printf("\r\nodd started\r\n");
                if(field == 1) { //赤ゾーン

                    switch(flag) {
                        case 0:
                            oddmetry[L]->odd_move(-1670);//赤ZONE
                            oddmetry[R]->odd_move(-1670);
                            flag = 1;
                            break;

                        case 1:
                            oddmetry[L]->odd_move(-880);//赤ZONE
                            oddmetry[R]->odd_move(-880);
                            flag = 2;
                            break;

                        case 2:
                            oddmetry[L]->odd_move(-600);//赤ZONE
                            oddmetry[R]->odd_move(-600);
                            flag = 3;
                            break;

                        case 3:
                            oddmetry[L]->odd_move(3150);//赤ZONE
                            oddmetry[R]->odd_move(3150);
                            flag = 0;
                            break;

                        default:
                            break;
                    }

                } else if(field == 0) { //青
                    switch(flag) {
                        case 0:
                            oddmetry[L]->odd_move(1550 - 500);//青ZONE //学校のロンリウムに合わせて50cmずらしてある
                            oddmetry[R]->odd_move(1550 - 500);
                            flag = 1;
                            break;

                        case 1:
                            oddmetry[L]->odd_move(580);//青ZONE
                            oddmetry[R]->odd_move(580);
                            flag = 2;
                            break;

                        case 2:
                            oddmetry[L]->odd_move(900);//青ZONE
                            oddmetry[R]->odd_move(900);
                            flag = 3;
                            break;

                        case 3:
                            oddmetry[L]->odd_move(-3030 + 500);//青ZONE//学校のロンリウムに合わせて50cmづらしてある
                            oddmetry[R]->odd_move(-3030 + 500);
                            flag = 0;
                            break;

                        default:
                            break;
                    }
                }

            }
        }
        //電磁弁
        for(int j = 1; j < 4; j++) {
            if(!(swdata >> j & 0x01) && (data >> j & 0x01)) {//立ち上がり
                char x = (char)j;
                i2c.write(add2,&x,1);
            }
            if((swdata >> j & 0x01) && !(data >> j & 0x01)) {//立下り
                char x = (char)j;
                i2c.write(add2,&x,1);
            }
        }
        //弓
        if(!(swdata >> 4 & 0x01) && (data >> 4 & 0x01)) {//立ち上がり
            bow.drive(0.5);
            i2c.write(add2,&logA,1);
        }
        if((swdata >> 4 & 0x01) && !(data >> 4 & 0x01)) {//立ちsaがり
            bow.drive(0);
            i2c.write(add2,&logA,1);
        }
        if(!(swdata >> 5 & 0x01) && (data >> 5 & 0x01)) {

            if(oddmetry[L]->odd_available() && oddmetry[R]->odd_available()) {//半自動(お止め鳥)
                //pc.printf("\r\nodd started\r\n");
                if(field == 1) { //赤ゾーン

                    switch(flag2) {
                        case 0:
                            oddmetry[L]->odd_move(-2350);//赤ZONE
                            oddmetry[R]->odd_move(-2350);
                            flag2 = 1;
                            break;

                        case 1:
                            oddmetry[L]->odd_move(2350);//赤ZONE
                            oddmetry[R]->odd_move(2350);
                            flag2 = 0;
                            break;

                        default:
                            break;
                    }

                } else if(field == 0) { //青
                    switch(flag2) {
                        case 0:
                            oddmetry[L]->odd_move(2350 - 500);//青ZONE //学校のロンリウムに合わせて50cmずらしてある
                            oddmetry[R]->odd_move(2350 - 500);
                            flag2 = 1;
                            break;

                        case 1:
                            oddmetry[L]->odd_move(-2350 + 500);//青ZONE
                            oddmetry[R]->odd_move(-2350 + 500);
                            flag2 = 0;
                            break;

                        default:
                            break;
                    }
                }

            }
        }
            swdata = data;

            //debug
            /*for(int i = 0; i < NUMBER; i++) {
                target[i] = mdp[i]->get_target();
                duty[i] = mdp[i]->get_duty();
                speed[i] = mdp[i]->get_speed();
                revolution[i] = mdp[i]->get_revolution();
            }*/


            /*for(int i = 0; i < NUMBER; i++) {
                pc.printf("no:%x",i);
                pc.printf("Targ:%f ",target[i]);
                pc.printf("Duty:%f ",duty[i]);
                pc.printf("Sped:%f ",speed[i]);
                pc.printf("Revol:%f \n\r\r\n",revolution[i]);
            }*/

            if(oddmetry[L]->odd_available() && oddmetry[R]->odd_available()) {//半自動の実行の有無を確認
                if(con.get_error() == 0) {
                    bike->move(con.get_axis(con.Stick0X),con.get_axis(con.Stick0Y));
                } else {
                    bike->move(0.0,0.0);
                }
                //pc.printf("L:%f R:%f\r\n",bike->duty[0],bike->duty[1]);
            }

            oddmetry[L]->odd_mock_timer();//tickerでi2c使えんらしい
            oddmetry[R]->odd_mock_timer();

            if(!oddmetry[L]->odd_available()) {
                //pc.printf("rotarion = %f \r\n",oddmetry[L]->odd_distance);
            }

            oddmetry[L]->odd_stopper();
            oddmetry[R]->odd_stopper();

            //pc.printf("err:%x\r\n",con.get_error());

            wait(0.02);
        }
    }