#ifndef B_MOTOR_ODDMETRY_H_
#define B_MOTOR_ODDMETRY_H_

#include <shared/MD/MD.h>
#include <shared/QEI/QEI.h>
#include "mbed.h"
#include <math.h>

#define odd_speed 0.15//duty

class B_motor_oddmetry
{
public:

    B_motor_oddmetry(MD *md,QEI *qei,double gain = 1.0);

    void odd_move(double mm);//±mm動かす
    bool odd_available();//オドメトリ実行中:0,終了時、未実行時:1
    void odd_stopper();//モータ停止、リセット処理
    void odd_mock_timer();//PID用、また回転の更新用

    double odd_distance;//回転、debugようにpublicなっとる
private:
    MD *_md;
    QEI *_qei;
    
    double force;//ぶっちゃけ正負だけ見とる
    double odd_distination;//mmで渡された移動距離を回転数に変換

    int odd_flag;//実行中か否か


    double _gain;//Rは-1やで
};

#endif

