#include "B_motor_oddmetry.h"
#define M_PI 3.14159265359
#define chircumustance 80.2//タイヤの直径

B_motor_oddmetry::B_motor_oddmetry(MD *md,QEI *qei,double gain)
{
    _gain = gain;
    this->_md = md;
    this->_qei = qei;
    force = 0.0;
    odd_flag  = 0;
    odd_distination = 0.0;
    odd_distance = 0.0;

}



void B_motor_oddmetry::odd_move(double mm)
{
    if(!odd_flag) {
        odd_flag = 1;
        _md->drive(0);
        _qei->reset_total_revolution();

        odd_distance = 0.0;
        odd_distination = fabs(mm) / (M_PI * chircumustance);//距離[mm] → 回転数[]
        force = mm;
        if(mm >= 0.0) {
            _md->drive(odd_speed * _gain);
        } else {
            _md->drive(-1.0 * odd_speed *_gain);
        }

    }

}

void B_motor_oddmetry::odd_mock_timer()
{
    if(odd_flag) {

        if(force > 0.0) {
            _md->drive(odd_speed * _gain);//PIDの使用上、drive()をやり続ける必要がある
        } else if(force == 0) {
            _md->drive(0);

        } else {

            _md->drive(-1.0 * odd_speed * _gain);
        }
        odd_distance = fabs(_qei->read_total_revolution());//回転の更新
    }
}

void B_motor_oddmetry::odd_stopper()
{
    if(odd_flag) {
        if(odd_distance >= odd_distination) {//停止して各種変数をリセット
            _md->drive(0);
            odd_distance = 0.0;
            odd_distination = 0.0;
            odd_flag = 0;
            force = 0;
            _qei->reset_total_revolution();
        }
    }
}

bool B_motor_oddmetry::odd_available()
{
    return !odd_flag;
}