#include "mbed.h"
#include "Debug.h"
#include "Stepp.h"
#include "EixoController.h"
#include "EixoMonitoring.h" 

#define LEFT  1
#define RIGHT 0
#define FRONT 1
#define BACK  0

// =============== Pinos Driver ===============
PinName clkPinX = p20;
PinName dirPinX = p19;
PinName enPinX  = p18;

PinName swOrignX = p11;
PinName swEndX   = p6;


//PinName clkPinZ = p17;
//PinName dirPinZ = p16;
//PinName enPinZ = p15;

//PinName swOrignZ = p7;
//PinName swEndZ   = p8;
// ============================================

// =============== Pinos Swtches ===============
DigitalIn swLeft(p11); //X0 --> origem
DigitalIn swRight(p6); //Xf --> fim
//DigitalIn swBack(p7); //Z0 --> origem
//DigitalIn swFront(p8); //Zf --> fim
// ============================================

Debug *debug  = new Debug();

Stepp* motorX = new Stepp(clkPinX, dirPinX, enPinX);
EixoController* eixoX = new EixoController( 55000, 14, motorX, swOrignX, swEndX);
EixoMonitoring* eixoMonitoring = new EixoMonitoring( swOrignX, swEndX) ;

// 0 - esquerda        1 - direita ---> Eixo X
// 1 - frente          0 - trás    ---> Eixo Z
// 1 - pressionado     0 - solto   ---> Switches

int main() { 

    
    bool teste = false;
    teste = eixoX->goToOrigem(swLeft , LEFT);
    
    /*EixoMonitoring::isCalibrated = false;           
    eixoMonitoring->startThreads();
          
    if(teste == 1){// se está na origem    
         eixoX->calibragem(RIGHT);           
         EixoMonitoring::isCalibrated = true;
         eixoMonitoring->hitSensor = 0;
         eixoMonitoring->stopAll = false;
         eixoX->goToPosition(5,RIGHT);   
    }
                
     eixoMonitoring->stopThreads();                */
}