#include "Microduino_Protocol_HardSer.h"

//BLE//////////////////////
Serial pc(D3, D2);

Protocol bleProtocol(&pc, TYPE_NUM);  //软串口,校验数据类

#define this_node  1  //设置本机ID
#define other_node 0
struct send_a { //发送
    uint32_t node_ms;   //节点运行时间
};
struct receive_a { //接收
    uint32_t ms;
    uint16_t rf_CH[CHANNEL_NUM];
};

//Mode//////////////////////
enum _Mode {
    NRF,
    BLE
};

bool protocolSetup(void)
{
    bleProtocol.begin(BLE_SPEED);
    return BLE;
}

bool protocolRead(uint16_t *_channel, bool _mode)
{
    switch (bleProtocol.parse(_channel, MODE_WHILE)) {
        case P_NONE:  //DATA NONE
            break;
        case P_FINE:  //DATA OK
            return true;
        case P_ERROR: //DATA ERROR

            break;
        case P_TIMEOUT: //DATA TIMEOUT

            break;
    }
    return false;
}
