#ifndef OLED_CPP_
#define OLED_CPP_
#include "mbed.h"
#include "oled.h"

//I2C g_i2c(P0_11, P0_10);//SDA, SCL
extern I2C g_i2c;
//Adafruit_SSD1306_I2c adaf(g_i2c, P0_13, 0x78, 64, 128);

//U8GLIB_SSD1306_MICRODUINO_128X64 u8g(U8G_I2C_OPT_NONE);     //设置OLED型号
//-------字体设置，大、中、小
#if 0
#define setFont_L u8g.setFont(u8g_font_7x13)
#define setFont_M u8g.setFont(u8g_font_fixed_v0r)
#define setFont_S u8g.setFont(u8g_font_chikitar)
#elif 0
#define setFont_L adaf.setTextSize(14)
#define setFont_M adaf.setTextSize(10)
#define setFont_S adaf.setTextSize(6)
#else
#define setFont_L
#define setFont_M
#define setFont_S
#endif

//温度计图案
unsigned char bmp_tem[] = {
    0xE0,0x81,0x30,0x83,0x10,0x82,0x10,0x82,0x10,0xFA,0x10,0x82,
    0x10,0x82,0x10,0xFA,0x10,0x82,0xD0,0x82,0xD0,0xFA,0xD0,0x82,
    0xD0,0x82,0xD0,0xFA,0xD0,0x82,0xD0,0x82,0xD0,0xFA,0xD0,0x82,
    0xD0,0x82,0xD8,0x86,0xC4,0x88,0xF2,0x93,0xFB,0xB7,0xF9,0xA7,
    0xFD,0xAF,0xFD,0xAF,0xF9,0xA7,0xFA,0x97,0xF2,0x93,0xC4,0x88,
    0x18,0x86,0xF0,0x83
};

//水滴图案
unsigned char bmp_hum[] = {
    0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x80,0x03,0x08,0x80,0x03,0x18,0x80,0x07,0x1C,
    0xC0,0x07,0x3C,0xC0,0x07,0x3E,0xE0,0x0F,0x3E,0xE0,0x0F,0x7A,0xF0,0x1F,0x7B,0xF8,
    0x1F,0x72,0xF8,0x1F,0x3E,0xF8,0x3F,0x1C,0xFC,0x3F,0x00,0xFC,0x7F,0x00,0xFE,0x7F,
    0x00,0xFE,0x7F,0x00,0xFE,0x7F,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0x00,
    0xF3,0xFF,0x00,0xF2,0x7F,0x00,0xE6,0x7F,0x00,0xC6,0x7F,0x00,0x0E,0x3F,0x00,0x3C,
    0x1E,0x00,0xF8,0x1F,0x00,0xE0,0x07,0x00,0x80,0x01
};

void oled_init(Adafruit_SSD1306_I2c &adaf)
{
    adaf.setTextColor(1, 0);
    //adaf.setTextColor(0, 1);
    adaf.setTextSize(1);
}

#if 0
void oled(float temp, float humi, float light, float pm25, float etoh)
//void oled(U8GLIB &u8g, float temp, float humi, float light, float pm25, float etoh)
{
    //gpio_write(&g_LED, 1);
    u8g.firstPage();
    do {
        u8g.setDefaultForegroundColor();

        u8g.drawXBMP( 4, 1, 15, 32, bmp_tem);
        u8g.drawXBMP( 70, 2, 24, 30, bmp_hum);

        setFont_M;                             //设置字体为大
        u8g.setPrintPos(20, 16);         //设置文字开始坐标
        u8g.print("`C ");
        setFont_L;                             //设置字体为大
        u8g.setPrintPos(20, 32);         //设置文字开始坐标
        u8g.print(temp , 1);             //温度

        u8g.setPrintPos(100, 16);         //设置文字开始坐标
        u8g.print("%");
        setFont_L;                             //设置字体为大
        u8g.setPrintPos(100, 32);         //设置文字开始坐标
        u8g.print(humi , 0);             //湿度

        setFont_L;                       //设置字体
        u8g.setPrintPos(4, 49);          //设置文字开始坐标
        u8g.print(light , 0);       //光照强度
        setFont_M;                       //设置字体
        u8g.print(" Lux");

        setFont_L;                       //设置字体
        u8g.setPrintPos(4, 63);          //设置文字开始坐标
        u8g.print(pm25 , 0);       //光照强度
        setFont_M;                       //设置字体
        u8g.print(" ug/m3");


        setFont_L;                       //设置字体
        u8g.setPrintPos(80, 49);          //设置文字开始坐标
        u8g.print(etoh , 0);       //光照强度
        setFont_M;                       //设置字体
        u8g.print(" ppm");

        // setFont_M;                             //设置字体为大
        // u8g.setPrintPos(80, 63);         //设置文字开始坐标
        // u8g.print(" LED:");

    } while( u8g.nextPage() );
    //gpio_write(&g_LED, 0);
}
#elif 1
void oled(Adafruit_SSD1306_I2c &adaf, float temp, float humi, float light, float pm25, float etoh)
{
    adaf.clearDisplay();
    
    //adaf.drawBitmap(4, 1, bmp_tem, 15, 32, WHITE);
    //adaf.drawBitmap(70, 2, bmp_hum, 24, 30, WHITE);

    //temp = 32.2;
    adaf.setTextCursor(0, 5);         //设置文字开始坐标
    adaf.printf("Temp:%.1f'C", temp);
    
    //light = 210.0;
    adaf.setTextCursor(74, 5);          //设置文字开始坐标
    adaf.printf("%.1fLux", light);            //光照强度
    
    //humi = 90.6;
    adaf.setTextCursor(0, 30);        //设置文字开始坐标
    adaf.printf("Humi:%.1f%%", humi);

    //pm25 = 9.7;
    adaf.printf("   %.1fug/m3", pm25);             //PM2.5
    
    //etoh = 2.6;
    adaf.setTextCursor(1, 52);         //设置文字开始坐标
    adaf.printf("%.1f ppm", etoh);             //甲醛
    
    adaf.drawFastVLine(69, 0, 63, WHITE);
    
    adaf.display();
}
#else
void oled(float temp, float humi, float light, float pm25, float etoh)
{
    static int16_t x = 0;
    static int16_t y = 0;
    adaf.clearDisplay();
    //adaf.setTextColor(0, 1);
    adaf.setTextCursor(x, y);
    adaf.printf("Lux\r\n");
    adaf.display();
    x += 2;
    if (x > 128) {
        x = 0;
        y += 2;
        if (y > 64) {
            y = 0;
        }
    }
}
#endif
#endif //OLED_CPP_