// Microduino_Stepper.cpp
//
// Copyright (C) 2009-2013 Shenyang
// $Id: Microduino_Stepper.cpp,v 1.00 2016/04/07 $

#ifndef __MICRODUINO_STEPPER_H__
#define __MICRODUINO_STEPPER_H__

//#include "MicroduinoPinNames.h"
#include "mbed.h"
#include <stdlib.h>
//#include <Arduino.h>

//#define _useTimer1
#define MAX_SPEED_S     4096
#define TIMER_COMP  327680/MAX_SPEED_S


//#define PIN_SET(pin) (*portOutputRegister(digitalPinToPort(pin)) |= digitalPinToBitMask(pin))
//#define PIN_CLR(pin) (*portOutputRegister(digitalPinToPort(pin)) &= ~digitalPinToBitMask(pin))

#define MAX_STEPPERS        4
#define INVALID_STEPPER     255

#if 0
#define PIN_EN      4      //PORTB,0
#define PIN_DIRA    A0    //PORTA,7
#define PIN_STEPA   5   //PORTB,1
#define PIN_DIRB    A1    //PORTA,6
#define PIN_STEPB   6   //PORTB,2
#define PIN_DIRC    A2    //PORTA,5
#define PIN_STEPC   7   //PORTB,3
#define PIN_DIRD    A3    //PORTA,4
#define PIN_STEPD   8   //PORTD,6
#elif 0
#define PIN_EN      D4
#define PIN_DIRA    A0
#define PIN_STEPA   D5
#define PIN_DIRB    A1
#define PIN_STEPB   D6
#define PIN_DIRC    A2
#define PIN_STEPC   D7
#define PIN_DIRD    A3
#define PIN_STEPD   D8
#else
#define PIN_EN      P0_25
#define PIN_DIRA    P0_7
#define PIN_STEPA   P0_24
#define PIN_DIRB    P0_6
#define PIN_STEPB   P0_1
#define PIN_DIRC    P0_14
#define PIN_STEPC   P0_20
#define PIN_DIRD    P0_23
#define PIN_STEPD   P0_19
#endif

#define DEFAULT_ACCEL 120

/* PWM的周期越小，频率越大，测试时发现这款步进电机的最大频率是2500Hz，也就是说周期为400us
 * 频率频率越大，步进电机的速度越大，至于脉冲的宽度，1us即可
 */
#define PERIOD_MAX    2000
#define PERIOD_MIN    450

void stepperAllEnable();
void stepperAllDisable();

class Stepper
{
public:

    Stepper(PinName dirPin, PinName stepPin);

    uint8_t begin();

    void setSpeed(int16_t _speed);

    void setMaxAccel(uint16_t _accel);

    int16_t getSpeed();

    uint16_t getMaxAccel();

    void computeStep();

private:
    pwmout_t    pwmStep;
    gpio_t      dirOUT;
    //gpio_t      stepOUT;
    uint8_t     stepperIndex;
    //uint8_t     dirPin;
    //uint8_t     stepPin;
    int16_t     speed;
    uint16_t    maxAccel;
    uint16_t    period;
    //uint16_t    counter;

};

typedef struct {
    //uint8_t isActive = false;
    uint8_t isActive;
    Stepper *stepper;
} Stepper_t;

#endif // __MICRODUINO_STEPPER_H__
