/* ライブラリのインクルード */
#include "mbed.h"
#include "LPS.h"
/* オブジェクトの生成 */
I2C i2c(p28, p27);
LPS ps(i2c);
/* メインプロフラム */
int main(){
    /* 初期設定 */
    wait_ms(100);
    if (!ps.init()){
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }
    ps.enableDefault();
    /* 繰り返し処理プログラム */
    while(1){
        float pressure = ps.readPressureMillibars();
        float altitude = ps.pressureToAltitudeMeters(pressure);
        float temperature = ps.readTemperatureC();
  
        printf("p:%.2ft mbarta:%.2f mtt:%.2f deg C\r\n",pressure,altitude,temperature);
        wait_ms(100);
    }
}            