#define mC 261.626
#define mD 293.665
#define mE 329.628
#define mF 349.228
#define mG 391.995
#define mA 440.000
#define mB 493.883
#include "mbed.h"
#include "LPS.h"
#include "HEPTA_CDH.h"
Timer t;
Serial pc(USBTX, USBRX); // tx, rx
Serial xbee(D1, D0); // tx, rx
I2C i2c(D4,D5);
LPS ps(i2c);
DigitalOut sp1(A0);
HEPTA_CDH cdh(PB_5, PB_4, PB_3, PA_8, "sd");
Ticker press;
Ticker sound;
int i;
int ct = 0;
float pressure = 0;
float altitude = 0;
float temperature = 0;
char cmd1,cmd2,cmd3;
int oto = 0;
float mm[]={mC*4,mD*4,mE*4,mF*4,mG*4,mA*4,mB*4,mC*8};   //timbre
void tick(void)
{
    sp1.write(oto);
    oto=!oto;
}
void pre() {
    xbee.printf("%.2f %.2f %.2f \r\n",pressure,altitude,temperature);
}
int main() {//1
    //Display from satellite to PC via xbee.
    pc.printf("settig start\r\n");
    xbee.printf("settig start\r\n");
    //Create a file to save the data acquired from the sensor to a microSD card
    //Also, if there is no microSD card, this error statement will be displayed
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    //If there is no Barometric Pressure Sensors, this error statement will appear in teraterm
    if (!ps.init()){//2
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }//2
    ps.enableDefault();
    //Display "begin" in teraterm and save it to SDcard
    pc.printf("begin\r\n");
    xbee.printf("begin\r\n");
    fprintf(fp,"begin\r\n");
    for (;;) {//2
        if (xbee.readable()) {//3
            pc.putc(xbee.getc());
            cmd1 = xbee.getc();
        //Input "m", the sensor data is displayed on the teraterm.
        //And the acquired data is saved to the SD card.
            if(cmd1 == 'm'){//4
                pc.printf("start\r\n");
                fprintf(fp,"start\r\n");
                xbee.printf("start\r\n");
                t.start();
                cmd1 = '\0';
                pc.printf("p[mbar] a[m] deg[C]\r\n");
                xbee.printf("p[mbar] a[m] deg[C]\r\n");
                fprintf(fp,"p[mbar] a[m] deg[C]\r\n");
                fclose(fp);
                press.attach(&pre, 0.1);
                //Save sensor acquisition data to SD card every 10 times
                while(1){//5
                    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
                    for(i = 0;i<10;i++){//6
                        pressure = ps.readPressureMillibars();
                        altitude = ps.pressureToAltitudeMeters(pressure);
                        temperature = ps.readTemperatureC();
                        fprintf(fp,"%d %.2f %.2f %.2f\r\n",ct,pressure,altitude,temperature);
                        ct = ct + 1;
                        if (xbee.readable()){//7
                            pc.putc(xbee.getc());
                            cmd2 = xbee.getc();
                            //Input "n", The command finishes acquiring air pressure
                            if(cmd2 == 'n'){//8
                                press.detach();
                                xbee.printf("end\r\n");
                                xbee.printf("time = %f",t.read());
                                fprintf(fp,"time = %f",t.read());
                                t.stop();
                                fclose(fp);
                                cmd2 = '\0';
                                while(1){//9
                                    for(i=0;i < sizeof(mm)/sizeof(mm[0]);i++) {
                                        sound.attach(&tick,1.0/mm[i]/2.0);  //If warning appear, ignore
                                        wait(0.5f);
                                        }//10
                                        sound.detach();
                                        i = 0;
                                    if (xbee.readable()){//10
                                        pc.putc(xbee.getc());
                                        cmd3 = xbee.getc();
                                        //Input "k", The command terminates the program.
                                        if(cmd3 == 'k'){//11
                                            pc.printf("end\r\n");
                                            sound.detach();
                                            //return 0;
                                                    }//11
                                                }//10
                                            }//9
                                        }//8
                                    }//7
                        wait_us(1);
                    }//6
                    fclose(fp);
                }//5
            }//4
        }//3
    }//2
}//1