#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 115200 bauds, 8-bit data, no parity
//------------------------------------

int m_nSec = 0;
bool m_bChange = false;

DigitalOut led1(LED1);
Serial pc(SERIAL_TX, SERIAL_RX, 115200);
Ticker toggle_led_ticker;
Ticker counter_ticker;

DigitalOut myled(LED1);

void toggle_led()
{
    led1 = !led1;
}

void count_second()
{
    m_nSec++;
    m_bChange = true;
}

int main()
{
    pc.printf("KKT : ticker + serial test\n");

    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (500 ms)
    toggle_led_ticker.attach(&toggle_led, 0.5);
    counter_ticker.attach(*count_second, 1);

    while(1) 
    {
        if (m_bChange)
        {
            m_bChange = false;
            pc.printf("This program runs since %d seconds.\n", m_nSec);
        }
    }
}
