#include "mbed.h"
#include "main.h"
#include "string.h"
#include "sx1272-hal.h"
#include "DS3231.h"
#include "LSM303DLHC.h"
#include "SDFileSystem.h"
// #include "EncoderCounter.h"

/*
 * Technion - Formula Car Telemetry
 * Part 1: Reading data signals from the car sensors and broadcasting them 
 */

/* Set this flag to '1' to display debug messages on the console */
#define DEBUG_MESSAGE   1

#define BUFFER_SIZE                                     32        // Define the payload size here

#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
DigitalOut led( LED2 );
#else
DigitalOut led( LED1 );
#endif

int main( void ) 
{
//    ENCODER enc(1);
//    int x = enc.XAxisGetCount();
    AnalogIn sus_rf(PA_0);
    AnalogIn sus_rr(PA_1);
    AnalogIn sus_lf(PA_4);    //       check if connected 
    AnalogIn sus_lr(PB_0);
    AnalogIn wheel_ang(PC_1);
    AnalogIn front_brake(PC_0);
    AnalogIn rear_brake(PC_3); //      check if connected 
    DS3231 TC(PB_7,PB_6);
    
    //PinName mosi, PinName miso, PinName sclk, PinName cs
    SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd"); 
    sd.mount();
    
    FILE *fp = fopen("/sd/formola_run.csv", "w");
    
    LSM303DLHC lsm303(PB_11, PB_10);
    
    // Real Time Clock
    int year = 0, month = 0, dayOfWeek = 0, date = 0, hours = 0, min = 0, sec = 0;
    TC.readDateTime(&dayOfWeek, &date, &month, &year, &hours, &min, &sec);
    
    BufferedSerial* ser = new BufferedSerial(USBTX,USBRX);
    ser->baud(115200*2);
    ser->format(8);
    
    fprintf(fp, "dayOfWeek: %d,date %d,month: %d,year: %d,hours: %d,minutes: %d,sec: %d\r\n", dayOfWeek,date,month,year,hours,min,sec);
    ser->printf("dayOfWeek: %d,date %d,month: %d,year: %d,hours: %d,minutes: %d,sec: %d\r\n", dayOfWeek,date,month,year,hours,min,sec);
    
    fprintf(fp, "sus_rf,sus_rr,sus_lf,sus_lr,wheel_ang,front_brake,accx,accy \r\n");
    ser->printf("sus_rf,sus_rr,sus_lf,sus_lr,wheel_ang,front_brake,accx,accy \r\n");
    
    
    
    while(1){
        float accelReading[3] = {0.0, 0.0, 0.0};
        lsm303.GetAcc(accelReading);
       
        ser->printf("%f,%f,%f,%f,%f,%f,%f,%f\n", sus_rf.read(), sus_rr.read(),
            sus_lf.read(), sus_lr.read(), wheel_ang.read(), front_brake.read(),
            rear_brake.read(), accelReading[0], accelReading[1]);
        
        wait(1);  
    }
   
}
