#include "mbed.h"
#include "nRF24L01P.h"
#define TRANSFER_SIZE   12
#define Send_Repeat_Times 10//命令重发次数
#define command_roll 0x51
#define command_start 0x50
#define command_end 0x52
#define command_slow 0x53

int flag=0;//发送状态标志 0：发送姿态命令 1：发送启动命令 2：发送急停命令 3：发送缓降命令
char txdata[TRANSFER_SIZE];

nRF24L01P my_nrf24l01p(PB_15, PB_14, PB_13, PB_6, PB_5, PB_7);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(PA_6);
DigitalOut myled2(PA_7);

//DigitalIn sz_n(PB_10),sz_p(PA_5),sx_p(PB_0),sx_n(PB_1),sy_p(PB_3),sy_n(PB_4);
AnalogIn L_X(PA_0),L_Y(PA_1),R_X(PA_2),R_Y(PA_3);
InterruptIn START(PB_4),END(PB_3),SLOW(PB_0);
Serial pc(PA_9,PA_10,9600);

void start(){flag=1;}
void end(){flag=2;}
void slow(){flag = 3;}

int main() {
    for(int i=0;i!=TRANSFER_SIZE;i++)
        txdata[i] = 0;   
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    myled1 = 0;
    myled2 = 0;
    
    START.mode(PullDown);
    END.mode(PullDown);
    SLOW.mode(PullDown);
    START.rise(&start);
    END.rise(&end);
    SLOW.rise(&slow);
    while (1) {
         switch (flag)
        {
            case 0:
                txdata[0]= command_roll;    
                short int data[4];
                data[0] = L_X.read_u16();
                data[1] = L_Y.read_u16();
                data[2] = R_X.read_u16();
                data[3] = R_Y.read_u16();
                txdata[2] = data[0];
                txdata[1] = data[0] >> 8;
                txdata[4] = data[1];
                txdata[3] = data[1] >> 8;
                txdata[6] = data[2];
                txdata[5] = data[2] >> 8;
                txdata[8] = data[3];
                txdata[7] = data[3] >> 8;
                txdata[9] = 0;
                txdata[10] = 0;
                txdata[11] = 0;    
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txdata, 12);
            break;        
            case 1:
                txdata[0] = command_start;
                for(int i=0;i<Send_Repeat_Times;i++) {my_nrf24l01p.write( NRF24L01P_PIPE_P0, txdata, 12); wait(0.01);}
                flag = 0;
            break;
            case 2:
                txdata[0] = command_end;
                for(int i=0;i<Send_Repeat_Times;i++) {my_nrf24l01p.write( NRF24L01P_PIPE_P0, txdata, 12); wait(0.01);}
                flag = 0;
            break;
            case 3:
                txdata[0] = command_slow;
                for(int i=0;i<Send_Repeat_Times;i++) {my_nrf24l01p.write( NRF24L01P_PIPE_P0, txdata, 12); wait(0.01);}
                flag = 0;
            break;      
        }
        wait(0.05);//防止过快发送造成命令无法被接收     
    }
}


