#include "mbed.h"
#include "BufferedSerial.h"
 #include"nRF24L01P.h"
Serial pc(PA_9, PA_10,  115200);//PA_9 PA_10 作为串口1连接串口转usb模块连接电脑
BufferedSerial mod(PA_2, PA_3, 32);//PA_2，PA_3作为第二个串口与jy-901的串口端连接，进行通信

nRF24L01P my_nrf24l01p(PB_15, PB_14, PB_13, PB_8, PB_9,PB_7);    // mosi, miso, sck, csn, ce, irq
 
int state, token, payloadLen, recvLen;
unsigned char payloadBuf[16];
 
void parseCmpt(int token, unsigned char* payloadBuf, int payloadLen)
{
    float data[3];
    switch(token){
        case 0x51:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
                data[i] = data[i] * 16 * 9.8 / 32768;
            }
            //pc.printf("Ax=%.2f\tAy=%.2f\tAz=%.2f\r\n", data[0], data[1], data[2]);
            break;
        case 0x52:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
                data[i] = data[i] * 2000 / 32768;
            }
            //pc.printf("Wx=%.2f\tWy=%.2f\tWz=%.2f\r\n", data[0], data[1], data[2]);
            break;
        case 0x53:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
                data[i] = data[i] * 180 / 32768;
            }
            pc.printf("Roll=%.2f\tPitch=%.2f\tYaw=%.2f\r\n", data[0], data[1], data[2]);
            break;
        case 0x54:
            for (int i = 0; i < 3; ++i)
            {
                data[i] = payloadBuf[i*2]|((int)payloadBuf[i*2+1]<<8);
            }
            //pc.printf("Hx=%.2f\tHy=%.2f\tHz=%.2f\r\n", data[0], data[1], data[2]);
            break;
    }
}
 
void parseInput(const char* data, int len)
{
    for (int i = 0; i < len; ++i)
    {
        unsigned char ch = data[i], sum;
        switch(state){
            case 0:
                if(ch == 0x55)
                    state = 1;
                break;
            case 1:
                token = ch;
                if(0x51 <= token && token <= 0x54){
                    payloadLen = 8;
                    recvLen = 0;
                    state = 2;
                }else{
                    pc.printf("%s %x\r\n", "unknown token", token);
                    state = 0;
                }
                break;
            case 2:
                payloadBuf[recvLen++] = ch;
                if(recvLen == payloadLen){
                    state = 3;
                }
                break;
            case 3:
                sum = 0x55;
                sum += token;
                for (int i = 0; i < payloadLen; ++i)
                {
                    sum += payloadBuf[i];
                }
                if(sum != ch){
                    pc.printf("wrong checksum\r\n");
                }else{
                    parseCmpt(token, payloadBuf, payloadLen);
                //    myled = !myled;
                }
                state = 0;
                break;
        }
    }
}
 
int main()
{
     while(1) {
        char ch;
        if(mod.readable()){
            ch = mod.getc();
            pc.printf(&ch);
        }
    }//只需将jy-901模块从串口传出的信息原封不动传到电脑即可 在电脑端打开jy模块自带的上位机软件即可查看jy模块的各种信息及可视化后的图像。
 /* #define TRANSFER_SIZE   4
 
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
 
    my_nrf24l01p.powerUp();
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
 
    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
 
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
 
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
 
 /*   while (1) {
 
        // If we've received anything over the host serial link...
        if ( pc.readable() ) {
 
            // ...add it to the transmit buffer
            txData[txDataCnt++] = pc.getc();
 
            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {
 
                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
 
                txDataCnt = 0;
            }
 
            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
            myled1 = !myled1;
        }
 
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
 
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
 
            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
 
                pc.putc( rxData[i] );
            }
 
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        }
    }*/  
}