#include "mbed.h"
//#include "EthernetInterface.h"
#include "WiflyInterface.h"
#include "Websocket.h"

#define WS_SERVER_IP_ADDR "ws://192.168.42.61:8080/"
#define SSID "mbed"
#define PASSPHRASE "6033937142"

static DigitalOut led1(LED1);
static DigitalOut led2(LED2);
static DigitalOut led3(LED3);
static DigitalOut led4(LED4);

static int count = 0;
static char buffer[2];

/* wifly object where:
*     - p13 and p14 are for the serial communication
*     - p22 is for the reset pin
*     - p21 is for the connection status
*     - SSID is the ssid of the network
*     - PASSPHRASE is the password
*     - WPA is the security
*/
WiflyInterface wifly(p13, p14, p22, p21, SSID, PASSPHRASE, WPA);

void static clear_leds () {
  led1 = led2 = led3 = led4 = 0;
}

void static counter () {
  if (count == 99) {
    count = 0;
  }
  count++;
  sprintf(buffer, "%d", count);
}

/*static int connect_eth () {
  EthernetInterface eth;
  // Use DHCP
  eth.init();
  eth.connect();
  // screen /dev/tty.usbmodem*
  //printf("IP Address is %s\n\r", eth.getIPAddress());
  return 0;
}*/

static int connect_wifi () {
  wifly.init(); // use DHCP
  while (!wifly.connect()); // join the network
  return 0;
}

static Websocket connect_ws (char* ip_addr) {
  // Viewable at: http://sockets.mbed.org/demo/viewer
  //Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");

  Websocket ws(ip_addr);
  //printf("WS Constructed\n\r");
  while(!ws.connect());
  //printf("WS Connected\n\r");
  return ws;
}

static Websocket connect (char* ip_addr) {
  clear_leds();
  //led1 = !connect_eth();
  led1 = !connect_wifi();
  Websocket ws = connect_ws(ip_addr);
  led2 = 1;
  return ws;
}

int main () {
  Websocket ws = connect(WS_SERVER_IP_ADDR);
  
  while (1) {
    counter();
    if (ws.is_connected()) {
      //printf("Sending...%s\n\r", buffer);
      ws.send(buffer);
    } else {
      clear_leds();
    }
    //wait(0.1);
  }
}