#include "mbed.h"
#include "hcsr04.h"
#include "SDBlockDevice.h"
#include  "FATFileSystem.h"
//#include "MQTTTimer.h"
//#include "CayenneMQTTClient.h"
//#include "MQTTNetworkIDW01M1.h"
#include "lorawan_network.h"
#include "CayenneLPP.h"
#include "mbed_events.h"
#include "mbed_trace.h"
#include "lora_radio_helper.h"
#include "SX1276_LoRaRadio.h"
#include "LoRaWANInterface.h"
//#include "stm32_standby.h"




//#define STANDBY_TIME_S                 1* 60

extern EventQueue ev_queue;

static uint32_t DEV_ADDR_1   =      0x260118FA;
static uint8_t NWK_S_KEY_1[] =      { 0x5D, 0xD5, 0xC9, 0x84, 0xB9, 0xCE, 0x26, 0x05, 0xB7, 0x61, 0xBF, 0x9F, 0x3C, 0x2D, 0x4E, 0x14 };
static uint8_t APP_S_KEY_1[] =      { 0xF0, 0xE4, 0xA1, 0xEB, 0x1F, 0xB5, 0x6E, 0xBA, 0x31, 0x69, 0x80, 0x9D, 0x85, 0x92, 0x68, 0xB4 };
SDBlockDevice sd(PC_12, PC_11, PC_10, D10);// mosi, miso, sclk, cs
FATFileSystem fs("sd");
FlashIAP flash;
 
void apply_update(FILE *file, uint32_t address);
 
HCSR04 sensor(D4, D3);
//Serial pc(USBTX, USBRX);
//FILE *fp;                                   // File pointer declear


int dw,d,M,y,h,m,s;  //VARIABLES FOR TIME AND YEAR


//global variable
long distance;

 bool dist_updated = false;
 float volume;  


    
void dist_measure(){
    sensor.start();
    wait_ms(100); 
    distance=sensor.get_dist_cm();
    volume = 6*6*(2-(distance*0.01));
    dist_updated = true;
    
    }
    
void check_for_updated_dist() { 

    if (dist_updated){
        dist_updated = false ;
        printf("Measure Distance = %ld ",distance);
        printf("Volume=%3.0f\n", volume);
        
        CayenneLPP payload(50);
        float volume_value = volume;
        printf("Volume_value=%f\n", volume_value);
        payload.addAnalogInput(4, volume_value);
        
        if (!lorawan_send(&payload)){
           // delete distance;
           // standby(STANDBY_TIME_S);
           
            }
        }
    }
/*void SetDateTime(int year = 2019, int mon = 1, int day = 1, int hour = 0, int min = 0, int sec = 0) {
    struct     tm Clock;
    Clock.tm_year = year - 1900;
    Clock.tm_mon  = mon - 1;      // note: subtract 1 
    Clock.tm_mday = day;
    Clock.tm_hour = hour;
    Clock.tm_min  = min;
    Clock.tm_sec  = sec;
    time_t epoch = mktime(&Clock);
    if (epoch == (time_t) -1) {
        error("Error in clock setting\n");
        // Stop here
    }
    set_time(epoch);
}*/

static void lora_event_handler(lorawan_event_t event) {
    switch (event) {
        case CONNECTED:
            printf("[LNWK][INFO] Connection - Successful\n");
            break;
        case DISCONNECTED:
            ev_queue.break_dispatch();
            printf("[LNWK][INFO] Disconnected Successfully\n");
            break;
        case TX_DONE:
            printf("[LNWK][INFO] Message Sent to Network Server\n");
            
         //   delete distance;
            //standby(STANDBY_TIME_S);
             
            break;
        case TX_TIMEOUT:
        case TX_ERROR:
        case TX_CRYPTO_ERROR:
        case TX_SCHEDULING_ERROR:
            printf("[LNWK][INFO] Transmission Error - EventCode = %d\n", event);
             

            //delete distance;
           // standby(STANDBY_TIME_S);
           
            break;
        case RX_DONE:
            printf("[LNWK][INFO] Received message from Network Server\n");
            receive_message();
            break;
        case RX_TIMEOUT:
        case RX_ERROR:
            printf("[LNWK][INFO] Error in reception - Code = %d\n", event);
            break;
        case JOIN_FAILURE:
            printf("[LNWK][INFO] ABP Failed - Check Keys\n");
            break;
        default:
            MBED_ASSERT("Unknown Event");
    }
}

void sd_write(){ 
   
 //END OF CODE USED FOR OBTAINING TIME
    sensor.start();
    wait_ms(100); 
    long distance=sensor.get_dist_cm();
     printf("distance is %dcm\n", distance);
     wait_ms(1000);      
     
    }
 int main() {
          
    printf("=========================================\n");
    printf("      Water Level Monitoring System        \n");
    printf("=========================================\n");
     char date[64];      //string for storing the current date
    char timeofday[64]; //string for storing the current time
    
       struct tm t;        //time structure for setting the time
   
    //set time structure to 20 Sep 2016 00:31:01
    time_t rawtime;
    //time_t seconds;     //time_t variable to read the number of seconds since January 1, 1970 for time calculations 
   //set_time(rawtime);
  struct tm * timeinfo;

  time ( &rawtime );
  timeinfo = localtime ( &rawtime );
  
  printf ( "Current local time and date: %s", asctime (timeinfo) );
    t.tm_year = 2019 - 1900;
    t.tm_mon = 6 - 1;
    t.tm_mday = 19;
    t.tm_hour = 14;
    t.tm_min = 23;
    t.tm_sec = 8;
         
    
    //use the time structure and set the real-time clock (RTC) time
    set_time(mktime(&t));
    while (true)
    {
    lorawan_setup(DEV_ADDR_1, NWK_S_KEY_1, APP_S_KEY_1, lora_event_handler);

    printf("Measuring Distance...\n");
  
    //immediately measure the distance
     sensor.start();
     wait_ms(100);
     distance = sensor.get_dist_cm();
    printf("Measuring Dist =%ld...\n",distance);
     
   
    // Try to mount the filesystem.
   printf("Mounting the filesystem... ");
 
    int err = fs.mount(&sd);
    printf("%s\r\n", (err ? "Failed :(\r\n" : "OK\r\n"));
    if (err)
        return err;    
      
      // Open a file.
    printf("Opening file '/sd/mylogger.txt'... ");
    FILE*  fp = fopen("/sd/mylogger.txt", "a");            // File open for "a"ppend
    if (fp == NULL) {                               // Error!
           // printf("Unable to write the file\r\n");
           
        } 
        else {
             char buffer[64];
        strftime(buffer, 64, "%I:%M %p\n", localtime(&rawtime));
       // printf("Time as a custom formatted string = %s", buffer);
        time_t seconds = time(NULL);                                           //read the new time value
        strftime(date, 64, "%d/%m/%y", localtime(&rawtime));            //create a date string from the time value
        strftime(timeofday, 64, "%H:%M:%S", localtime(&rawtime));       //create a time string from the time value     
        fprintf(fp, "%s %s %dcm\r\n", date, timeofday, distance);   //write the date string, time string, and analog integer value to the file
                                                                                //the /r/n combination puts the entries on different lines in the file
    //printf("%dcm ",distance);          // Append data to SD card.
    //fprintf(fp, "%dcm\r\n",distance);        // Serial monitor.
        }
    fclose(fp); 
                                       // Cloce file.
                                       wait(20);
    printf("File successfully written!\r\n");    // Serial monitor.    
    dist_measure();
    ev_queue.call_every(3000, &check_for_updated_dist);       
    ev_queue.dispatch_forever();

     printf ( "Current local time and date: %s", asctime (timeinfo) );
      
    }  
    
}