#include "mbed.h"

#define tuss 2
#define tusl 20
#define tms 2

#define OFF 1
#define ON 0

Serial pc(USBTX, USBRX); // tx, rx 

SPI lcd(PTE3, PTE1, PTE2);
DigitalOut cs(PTE4);
DigitalOut res(PTD5);
DigitalOut dc(PTC12);
char k;   

void init_LCD(){
    res = 0;
    dc = 0;
    cs = 1;
    wait(0.1);
    res = 1;
    k = 0;
    cs = 0;
    lcd.write(0x3C);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);
    cs = 0;
    lcd.write(0x0C);
    wait_us(tuss);
    cs = 1;
    wait_us(tusl);
    cs = 0;
    lcd.write(0x01);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);
    cs = 0;
    lcd.write(0x06);
    wait_us(tuss);
    
    return;        
}

void pula_linha(){    
    dc = 0;
    wait_ms(tms);
    cs = 0;
    lcd.write(0xC0);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);
    
    dc = 1;
    wait_ms(tms);
    
    return;
}    

void limpa_lcd(void){
    
    dc = 0;
    wait_ms(tms);
    cs = 0;
    lcd.write(0x01);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);
    
    dc = 1;
    wait_ms(tms);
    
    return;
}

int main() {
    pc.baud(9600);
    
    lcd.format(8, 3); // Modo 0 ou 3
    lcd.frequency(1000000); // 100kHz
    
    init_LCD();
    
    cs = 1;
    wait_ms(tms);    
    dc = 1;
    wait_ms(tms);

    for(k = 0x30; k < 0x3A; k++) {
        cs = 0;
        lcd.write(k);
        wait_us(tuss);
        cs = 1;
        wait_ms(tms);
    }
    
    pula_linha();
    
    for(k = 'A'; k < 'Q'; k++) {
        cs = 0;
        lcd.write(k);
        wait_us(tuss);
        cs = 1;
        wait_ms(tms);
    }
    
    wait(5);
    
    limpa_lcd();    
}
