#include "mbed.h"
#include "eeprom.h"
#include "MFRC522.h"
 
//KL25Z Pins for MFRC522 SPI interface
 #define SPI_MOSI    PTC6
 #define SPI_MISO    PTC7
 #define SPI_SCLK    PTC5
 #define SPI_CS      PTC4
// KL25Z Pin for MFRC522 reset
 #define MF_RESET    PTC3
  
//Pinos EEPROM
#define SDA PTC2            // I2C SDA pin
#define SCL PTC1           // I2C SCL pin 
#define EEPROM_CONTROL_BYTE 0xA0
#define I2C_READ 0x01

#define OFF 1
#define ON 0

 DigitalOut LedRed   (LED_RED);
 DigitalOut LedGreen (LED_GREEN); 
 
EEPROM i2c(SDA, SCL, 0, EEPROM::T24C16);      // T24C01 should work for the 24AA02E48 eeprom
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET); 
 
//I2C i2c(PTE0, PTE1); // sda, scl on KL25Z
Serial pc(USBTX, USBRX); // tx, rx 
 
void escreve_mem(int8_t dado, uint8_t i){
    int8_t buf, elementos;
    
    LedGreen = 0;
    i2c.read(0, elementos); wait_ms(1);
    buf=dado;
    i2c.write(5*elementos+1+i, buf); wait_ms(1);//escreve na memoria    
}

/*char read_mem(uint8_t elemento, uint8_t i){
    char x;
    uint8_t buf, elementos;
    
    i2c.read(0, elementos); wait_ms(1);
    if (elementos < elemento){
        printf("não há numero de elementos na memória");
        return=-1;
    }else{
        i2c.read(5*(elemento-1)+1+i, buf); wait_ms(1);
        x=buf;
        return x;
    }
}*/

/*int varre_mem( uint8_t *s){
    int8_t elementos=0;
    uint8_t i = 0,buf;
    uint8_t *compara;
    int k;
    
    i2c.read(0, elementos); wait_ms(1);
    for (k=0;k==elementos;k++){ 
        for (i=0; i < RfChip.uid.size; i++){
            i2c.read(5*(elementos-1)+1+i, buf); wait_ms(1);
            compara[i]=buf;
        }
        if (compara==s) return 0; //retorna zero se encontrar id ja registrado
    }
    
    return 1; //retorna 1 se nao encontrar id igual
}*/
 
int main(void) {
    int encontrou=0;
    int t,jafalou=0,flag_registro=1, flag_identificacao=0, senha;
    char idcartao[4],compara[4];//vetor que grava id do cartao
    char x;
    int8_t buf=0, elementos,elemento,buf1;
    uint8_t i = 0,k;

    pc.baud(9600);
    
    // Init. RC522 Chip
    RfChip.PCD_Init();
    
    i2c.write(0, 0); wait_ms(1);//escreve 0 elementos na memoria
    
    while (true){     
     i2c.read(0, elementos); wait_ms(1);
    
     if(elementos==0 && jafalou==0){
        printf("Nenhum cartao registrado!\n\r");
        printf("Favor aproximar os cartoes a serem registrados\n\r");
        jafalou=1;
     }
     inicio:     
     LedGreen = 1;
     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent())
     {
       wait_ms(500);
       continue; 
     }
     
     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
       wait_ms(500);
       continue; 
     }
     if(flag_registro==1){
     //verifica se cartao ja foi registrado
     if (elementos != 0){         
         for (i=0; i < RfChip.uid.size; i++){            
            buf=RfChip.uid.uidByte[i];
            idcartao[i]=buf;
         }
         i2c.read(0, elementos); wait_ms(1);
         for (k=0;k<elementos;k++){ 
            for (i=0; i < RfChip.uid.size; i++){
                i2c.read(5*(elementos-1)+1+i, buf); wait_ms(1);
                compara[i]=buf;
            }
            if ((compara[0] == idcartao[0]) &&
                (compara[1] == idcartao[1]) &&
                (compara[2] == idcartao[2]) &&
                (compara[3] == idcartao[3])){
                printf("cartao ja registrado\n\r");
                goto inicio;
            }
        }
     }
          
     //escrita na memoria
     printf("\n\r");
     //if(flag_registro==1){
        for (i=0; i < RfChip.uid.size; i++){ 
            escreve_mem(RfChip.uid.uidByte[i], i);
        }
        elementos++;
        i2c.write(0, elementos); wait_ms(1);
        i2c.read(0, elementos); wait_ms(1);
        printf("\n\r");
        printf("elementos: %d\n\r", elementos);
     //}
     //le o que esta na memoria
     printf("memoria: ");
     //elemento=2;
     //if (elemento<elementos){
     //     printf("nao exite esse numero de elementos na memoria");
     //}else {
        for (i=0; i < RfChip.uid.size; i++){
            i2c.read(5*(elementos-1)+1+i, buf); wait_ms(1);
            x=buf;
            printf(" %d", x);     
        }  
     //}
     
     /*for (i=0; i < RfChip.uid.size; i++){
        idcartao[i]=read_mem(elemento, i);
     }
     for (i=0;i<4;i++){
         printf(" %d", idcartao[i]);
     }*/
     printf("\n\r");
     printf("\n\r");
     wait_ms(200);
     
     printf("Senha:");
     scanf("%d", &senha);
     printf("senha %d\n\r", senha);
     buf=senha;
     i2c.write(5*elementos, buf); wait_ms(1);
     
     printf("Deseja continuar a registrar cartoes?\n\r");
     printf("1:Sim 2:Nao\n\r");
     scanf("%d", &t); //le botao se 1 goto comeco e anda pos na memoria se 2 continua 
     printf("\n\r");
     if (t==1)goto inicio;
     if (t==2){
         printf("Fim registros!\n\r");
         flag_registro=0;
     }
     }
     else{
         printf("Passe cartao para obter acesso\n\r");
         for (i=0; i < RfChip.uid.size; i++){            
            buf=RfChip.uid.uidByte[i];
            idcartao[i]=buf;
         }
         i2c.read(0, elementos); wait_ms(1);
         for (k=0;k<elementos;k++){ 
            for (i=0; i < RfChip.uid.size; i++){
                i2c.read(5*(elementos-1)+1+i, buf); wait_ms(1);
                compara[i]=buf;
            }
            if ((compara[0] == idcartao[0]) &&
                (compara[1] == idcartao[1]) &&
                (compara[2] == idcartao[2]) &&
                (compara[3] == idcartao[3])){
                printf("cartao encontrado!\n\r");
                printf("Digite a senha\n\r");
                scanf("%d", &senha);
                printf("senha %d\n\r", senha);
                buf1=senha;
                encontrou=1;
            }
        }
        if(encontrou==1){
        encontrou=0;
        i2c.read(5*elementos, buf); wait_ms(1);
        if (buf1==buf){
            printf("acesso permitido\n\r"); 
            goto inicio;
        }else {
            printf("acesso negado\n\r");
            goto inicio;
        }
        }
     }
   }                   
}