//Buttons zum ein und ausschalten der Messung

//Sensor data sheet https://www.sensirion.com/fileadmin/user_upload/customers/sensirion/Dokumente/8_Differential_Pressure/Datasheets/Sensirion_Differential_Pressure_Datasheet_SdP8xx_Analog.pdf

//Messung via printf auf CMD Zeil ausgeben, mit P5 serial connector verscuchen abzugreifen

//Druck respektive die Konstruktion zum Sensor & Ventouri vorbereiten

//Ventouri richtig rechnen, mit Luftvolumen von Lunge und der Range des Sensors

//Baud Rate 115200


#include "mbed.h"
#include "platform/mbed_thread.h"

/* PM2_Libary */
#include "EncoderCounter.h"
#include "Servo.h"
#include "SpeedController.h"
#include "FastPWM.h"
#include "RangeFinder.h"

#include "math.h"

using namespace std::chrono;

InterruptIn user_button(USER_BUTTON);
DigitalOut led(LED1);
Timer runtimeTimer, user_button_timer;

bool executeMainTask = false;
int Ts_ms = 50;

//initialize functions
void button_fall();
void button_rise();
float readSensor(AnalogIn sensor);
float map_pressure_sensor(float input);
void printP5(int value);
void printSerialPlotter(int v1 , int v2);
float venturiSpeed(float DiaEntry, float DiaNarrow, float densAir, float dP);
float venturiFlow(int timeStart, int timeStop);
float getCirlceArea(float diameter);
//float detectBreath(float aiflow, int start, int stop);
bool detectBreath(float mappedSensorValue);

//Analog Port for sensor 
AnalogIn analogIn(PA_0);
float pressureDifference = 0.0f;
float VDD = 3.3f;


//Venturi Pipe parameters
float DiaEntry = 6 * 10e-3;     //m
float DiaNarrow = 2.2 * 10e-3;    //m
float densityAir = 1.2041;      //kg/m^3
float pi = 3.14159;
int threshold = 5;

int nBreath = 0;
float totalBreathVolume = 0;
float currentBreathVolume = 0;

int main(){
    
    int i = 0;
    runtimeTimer.start();
    user_button.fall(&button_fall);
    user_button.rise(&button_rise);
    int last_print = -999999;

   // printf("System running %f\n\r", pressureDifference);
    while(true){
        if (executeMainTask){
            
            i = 0;

            //pressureDifference = analogIn.read()*VDD;      
            pressureDifference = readSensor(analogIn);
            float dP = map_pressure_sensor(pressureDifference);
            
            int timestamp = runtimeTimer.elapsed_time().count();
            float speed = venturiSpeed(DiaEntry, DiaNarrow, densityAir, dP);
            float airVolume = venturiFlow(timestamp, last_print);
            totalBreathVolume += airVolume;
            if (detectBreath(dP)){
                currentBreathVolume += airVolume;
            } else if (!detectBreath(dP)){
                currentBreathVolume *= 0.1;
            }
            if ((timestamp-last_print) > 50000){
                //printf("%d, %d, %f, %f, %f, %f, %f, %f\n\r", timestamp,last_print,dP, pressureDifference,speed, airVolume, currentBreathVolume ,totalBreathVolume);
                printf("%f, %f, %f, %f, %f, %f\n\r", dP, pressureDifference,speed, airVolume, currentBreathVolume ,totalBreathVolume);
                last_print = timestamp;
                
            }
            led != led;
        }

        else {
            if (i==0){
                printf("Program paused, waiting until button gets pressed!\r\n");
                i = 1;
                }
        }
    }
}

void button_fall()
{
    user_button_timer.reset();
    user_button_timer.start();
}
 
void button_rise()
{
    int t_button = duration_cast<milliseconds>(user_button_timer.elapsed_time()).count();
    user_button_timer.stop();
    if(t_button > 200) executeMainTask = !executeMainTask;
}

float readSensor(AnalogIn sensor){
    return sensor.read() * VDD;
}

float map_pressure_sensor(float input){
    float dP;
    dP = ((750*input)/VDD) - 150;
    if (abs(dP)< threshold){                    //Filtering out noise 
        dP = 0;
    }
    

    return dP;
}

void printP5(int value){
    printf("%d\r\n", value);
}

void printSerialPlotter(int v1 , int v2){
    printf("%d %d",v1,v2);
}

float venturiSpeed(float DiaEntry, float DiaNarrow, float densAir, float dP){
    //formula https://www.leifiphysik.de/mechanik/stroemungslehre/ausblick/venturi-rohr
    float vEntry;
    float A1 = getCirlceArea(DiaEntry);
    float A2 = getCirlceArea(DiaNarrow);
    float absdP = abs(dP);
    vEntry = sqrt(abs((2*dP)/(densAir*((pow((A1-A2),2)-1))))); 
    if(dP < 0){
        vEntry = (-1)*vEntry;
    }
    return vEntry;
}

float venturiFlow(int timeStart, int timeStop){
    float volume;
    float flowSpeed = venturiSpeed(DiaEntry, DiaNarrow, densityAir, map_pressure_sensor(pressureDifference));
    float flowRate = flowSpeed * getCirlceArea(DiaEntry);
    int timeDelate = timeStop - timeStart;          //Microseconds
    volume = timeDelate *10e-6 * flowRate;           //to SI 
    return abs(volume);
}

float getCirlceArea(float diameter){
    float area = (pow(diameter/2,2))*pi;
    return area;
}

bool detectBreath(float mappedSensorValue){
    if (mappedSensorValue > 6){
        return true;
    }else{
        return false;
    }
}