
#include "mbed.h"

/** Simple class for controlling LEDs 
 * 
 * Author: Andrew Edwards
 *
 * Example of use:
 * @code
 * #include "mbed.h"
 * #include "LEDControl.h"
 *
 * int main() {
     Timer LEDTime; // Create a Timer for the LEDs to use that isn't used by anything else. Multiple LED objects can all use the same timer.
 *    LEDControl Blue(PC_10, &LEDTime); //There is a blue LED on pin PC_10 and it'll use the LEDTime timer.
 *    LEDControl Green(PA_13, &LEDTime); // There is a Green LED on pin PA_13 and it'll use the LEDTime Timer.
 *    Green.blink(); //default Blink rate is 10Hz, so green will blink at 10Hz
 *    Blue.on(); //Turn on the Blue LED. It'll stay on until off() is called.
 *    wait(2);
 *    Green.off(); // Turn Green off
 *    Green.toggle(); // This just toggles the LED from it's current state. If it's off, it'll go on. 
 *    Blue.blink(); // Blue blinks at 10hz
 *    Blue.blink(100); // Blue Blink at 100Hz
 *    Blue.off(); // LED OFF
 * }
 */
 
 
class LEDControl {
private:
    Timer *_Time;
    DigitalOut _led;
    float _nextBlink;
public:
    LEDControl(PinName pin, Timer *time);
    //void blink(int n, float t = 0.2);
    void blink(float rate = 5);
    void off();
    void on();
    void toggle();
};
