#include "LEDControl.h"
#include "mbed.h"

LEDControl::LEDControl(PinName pin, Timer *time):
    _led(pin),
    _nextBlink( 0 ),
    _Time ( time )
{
    _led = 0;
}

void LEDControl::blink(float rate) {
   long _currentTime = _Time->read_ms();
   
   if(_nextBlink - _currentTime > 5000)
   {
        _nextBlink = 0;
   }
   
   if(_currentTime - _nextBlink > 0)
   {
        if(_currentTime > 30000)
        {
            _Time->reset();
            _currentTime = 0;
        }
        _led = !_led; 
        _nextBlink = 1000/rate + _currentTime;
   }  
}
void LEDControl::off() {
   _led = 0;
}

void LEDControl::on() {
   _led = 1;
}

void LEDControl::toggle() {
   _led = !_led;
}