//programme a mettre sur les cartes de l'equipe 1, pour l'equipe 2 le calcul sur le tire sur un coequipier doit changer

#include "mbed.h"
#include "arm_math.h"
#include "dsp.h"
#include "arm_common_tables.h"
#include "arm_const_structs.h"
#include "nRF24L01P.h"

#define TRANSFER_SIZE           8
#define SAMPLES                 512             /* 256 real party and 256 imaginary parts */
#define FFT_SIZE                SAMPLES / 2     /* FFT size is always the same size as we have samples, so 256 in our case */
 
float32_t Input[SAMPLES];
float32_t Output[FFT_SIZE];
bool      trig=0;
int       indice = 0;

DigitalOut  myled(D13);
AnalogIn    myADC(A0);
Serial      debug_pc(USBTX, USBRX);
Ticker      timer;

DigitalIn bouton(D7);

// nRF24
char k;
char    dataToSend[TRANSFER_SIZE] = {0xAA, 0x01, 0x10, 0xF0,0xAA, 0x01, 0x10, 0xF0};
char    dataReceived[TRANSFER_SIZE] = {0};
char    rxDataCnt;

nRF24L01P       nRF24_mod(D11, D12, D13, D10, D9, PB_8);
// MOSI, MISO, SCK, CSN, CE, IRQ

#define index_equipe1      73 /* a  corriger */
#define index_equipe2      64  /* a corriger */
#define epsilon  2

/* definition des entrees des 3 capteurs: epaule droit, gauche et ventre */
AnalogIn cap_ventre(A0);
AnalogIn cap_epaule_droit(A1);
AnalogIn cap_epaule_gauche(A2);  

float32_t Input_ventre[SAMPLES];
float32_t Output_ventre[FFT_SIZE];

float32_t Input_epaule_droit[SAMPLES];
float32_t Output_epaule_droit[FFT_SIZE];

float32_t Input_epaule_gauche[SAMPLES];
float32_t Output_epaule_gauche[FFT_SIZE];

int nbr_pts_equipe1;
int nbr_pts_equipe2;    

// Fonction d'initialisation du module BT nRF24L01
void initNRF24(){
    nRF24_mod.powerUp();
    wait_us(100000);
    nRF24_mod.setAirDataRate(NRF24L01P_DATARATE_250_KBPS);
    nRF24_mod.setRfFrequency(2400);
    wait_us(100000);
    debug_pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  nRF24_mod.getRfFrequency() );
    debug_pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  nRF24_mod.getRfOutputPower() );
    debug_pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", nRF24_mod.getAirDataRate() );
    debug_pc.printf( "Transfers are grouped into %d characters\r\n", TRANSFER_SIZE );
    nRF24_mod.setTransferSize( TRANSFER_SIZE );
    nRF24_mod.setReceiveMode();
    nRF24_mod.enable();
}

// Fonction de test du module BT nRF24L01
void testNRF24(void){
    /* Lecture donnée depuis nRF24 */
    if ( nRF24_mod.readable() ) {
debug_pc.printf(" 1");
        // ...read the data into the receive buffer
        rxDataCnt = nRF24_mod.read( NRF24L01P_PIPE_P0, dataReceived, TRANSFER_SIZE);
debug_pc.printf(" 2");
        // Display the receive buffer contents via the host serial link
        debug_pc.printf("\tD = ");
        for ( int i = 0; i < rxDataCnt; i++ ) {
            debug_pc.printf(" %d \t", dataReceived[i]);
            debug_pc.printf(" Recu");
        }
        debug_pc.printf("\r\n");
    }  
    debug_pc.printf(" 3") ;
    /* Transmission donnée depuis nRF24 */
    if(dataReceived[0] == 0){
        nRF24_mod.setRfFrequency(2400);
        nRF24_mod.write( NRF24L01P_PIPE_P0, dataToSend, TRANSFER_SIZE );
        debug_pc.printf( "Nombre de point equipe 1: %d \r \n Nombre de point equipe 2: %d \r \n, largeur du signal: %d \r \n", 10 * dataToSend[1],10 * dataToSend[2],dataToSend[3]);
        debug_pc.printf( "SENDED\r\n");
    }
}

// echantillonnage
void sample(){
    myled = 1;
    if(indice < SAMPLES){
        Input_ventre[indice] = cap_ventre.read() - 0.5f;
        Input_epaule_droit[indice] = cap_ventre.read() - 0.5f;
        Input_epaule_droit[indice] = cap_ventre.read() - 0.5f;    
        
        //Real part NB removing DC offset
        Input_ventre[indice + 1] = 0;    
        Input_epaule_droit[indice + 1] = 0;
        Input_epaule_gauche[indice + 1] = 0;    
                 
        //Imaginary Part set to zero
        indice += 2;
    }
    else{ trig = 0; }
    myled = 0;
}
 
int main() {
    float maxValue_ventre;            // Max FFT value is stored here (la largeur du care envoye par la led et detecte par la photodiode place sur le ventre) 
    float maxValue_epaule_droit;   
    float maxValue_epaule_gauche;  
    
    uint32_t maxIndex_ventre;         // Index in Output array where max value is
    uint32_t maxIndex_epaule_droit;
    uint32_t maxIndex_epaule_gauche;
    
    initNRF24();
    while(1) {
        if(trig == 0){
            
//calcul de la TF du signal detecte pour recuperer sa largeur 
            timer.detach();
            // Init the Complex FFT module, intFlag = 0, doBitReverse = 1
            //NB using predefined arm_cfft_sR_f32_lenXXX, in this case XXX is 256
            arm_cfft_f32(&arm_cfft_sR_f32_len256, Input_ventre, 0, 1);
            arm_cfft_f32(&arm_cfft_sR_f32_len256, Input_epaule_droit, 0, 1);
            arm_cfft_f32(&arm_cfft_sR_f32_len256, Input_epaule_gauche, 0, 1);
 
            // Complex Magniture Module put results into Output(Half size of the Input)
            arm_cmplx_mag_f32(Input_ventre, Output_ventre, FFT_SIZE);
            arm_cmplx_mag_f32(Input_ventre, Output_epaule_droit, FFT_SIZE);
            arm_cmplx_mag_f32(Input_ventre, Output_epaule_gauche, FFT_SIZE);
            
            Output_ventre[0] = 0;
            Output_epaule_droit[0] = 0;
            Output_epaule_gauche[0] = 0;
            Output[0] = 0;
            //Calculates maxValue and returns corresponding value            
            arm_max_f32(Output_ventre, FFT_SIZE/2, &maxValue_ventre, &maxIndex_ventre);
            arm_max_f32(Output_epaule_droit, FFT_SIZE/2, &maxValue_epaule_droit, &maxIndex_epaule_droit);
            arm_max_f32(Output_epaule_gauche, FFT_SIZE/2, &maxValue_epaule_gauche, &maxIndex_epaule_gauche);
            

            
// Calcul des points
            //Tire sur un coequipier :
            if (maxIndex_ventre<(index_equipe1+epsilon) && maxIndex_ventre>(index_equipe1-epsilon) )
            {
                nbr_pts_equipe1=nbr_pts_equipe1-2; // -2pts pour l'equipe du tireur
            }
            if (maxIndex_epaule_droit<(index_equipe1+epsilon) && maxIndex_epaule_droit>(index_equipe1-epsilon) )
            {
                nbr_pts_equipe1=nbr_pts_equipe1-2; // -2pts pour l'equipe du tireur
            }
            if (maxIndex_epaule_gauche<(index_equipe1+epsilon) && maxIndex_epaule_gauche>(index_equipe1-epsilon) )
            {
                nbr_pts_equipe1=nbr_pts_equipe1-2; // -2pts pour l'equipe du tireur
            }
            
            //Tire sur le ventre   
            if (maxIndex_ventre<(index_equipe2+epsilon) && maxIndex_ventre>(index_equipe2-epsilon)) 
            {
                nbr_pts_equipe1=nbr_pts_equipe1-1; //Tire sur le ventre : -1pts pour l'equipe de la victime
                nbr_pts_equipe2=nbr_pts_equipe2+5; //Tire sur le ventre : +5pts pour l'equipe du tireur
            }   
            
            //Tire sur l'epaule
            if ((maxIndex_epaule_droit<(index_equipe2+epsilon))&& (maxIndex_epaule_droit>(index_equipe2-epsilon)) || ((maxIndex_epaule_gauche<(index_equipe2+epsilon))&& (maxIndex_epaule_gauche>(index_equipe2-epsilon))))
            {
                nbr_pts_equipe1=nbr_pts_equipe1-1; //Tire sur l'epaule : -1pts pour l'equipe de la victime
                nbr_pts_equipe2=nbr_pts_equipe2+10; //Tire sur l'epaule : +10pts pour l'equipe du tireur
            }
            
// Envoie du nombre de point au ordinateur par bluetooth 
            if (bouton==1){
            dataToSend[1] = nbr_pts_equipe1;
            dataToSend[2] = nbr_pts_equipe2;
            dataToSend[3] = maxValue_ventre;
            testNRF24();
            wait(0.5);}            
         

// Relance de l'acquisition
            trig = 1;
            indice = 0;
            //(version prof) timer.attach_us(&sample,40);      //20us 50KHz sampling rate
            timer.attach_us(&sample,50); //critere de shannon
        }
    

}}