/***************************************************************************
 * @author Wacomg
 *
 * @section LICENSE
 *
 * Copyright (c) 2017 Wacomg
 *
 * @section DESCRIPTION
 *
 *  AD7680.CPP
 *  Source file for AD7680 class library
 *  The AD7680 is a 16-bits, 1-channel, SPI-interfaced ADC from Analog Devices
 *  
*****************************************************************************/

#include "ad7680.h"


// Constructor
AD7680::AD7680(PinName MISO, PinName SCLK, PinName CS, int frequency) : _spi(NC, MISO, SCLK), _cs(CS) {    
    _spi.frequency(frequency);
    _spi.format(24, 0);
    _cs = 1;
    _q = (double) 5.0/65535.0;;
};


    
void AD7680::readRAW(int16_t *rawDataBuffer) {
    uint8_t lowByte, medByte, highByte;
    _cs = 0; 
        highByte = _spi.write(0x00);    
        medByte = _spi.write(0x00);    
        lowByte = _spi.write(0x00);

        *(rawDataBuffer + 0) = (int16_t) ((highByte << 12) + (medByte<<4) + (lowByte>>4));    
    _cs = 1;
}

void AD7680::readAnalog(double *analogDataBuffer) {
    uint8_t lowByte, medByte, highByte;
    _cs = 0; 
        highByte = _spi.write(0x00);    
        medByte = _spi.write(0x00);    
        lowByte = _spi.write(0x00);

        *(analogDataBuffer +0 ) = (double) (uint16_t)((highByte << 12) + (medByte<<4) + (lowByte>>4))*_q;    
    _cs = 1;
}
