/***************************************************************************
 * @author Wacomg
 *
 * @section LICENSE
 *
 * Copyright (c) 2017 Wacomg
 *
 * @section DESCRIPTION
 *
 *  AD7680.H
 *  Header file for AD7680 class library
 *  The AD7680 is a 16-bits, 1-channels, SPI-interfaced ADC from Analog Devices
 *  
*****************************************************************************/
#ifndef AD7680_H
#define AD7680_H

#include "mbed.h"

class AD7680 {
    private:
        SPI _spi;
        DigitalOut _cs;
        double _q;

    public:
        AD7680(PinName MISO, PinName SCLK, PinName CS, int frequency); // Constructor
        void readRAW(int16_t *); // Read raw values from ADC
        void readAnalog(double *); // Read analog values
};

#endif