// Phase-shifted PWM Test Code
// 
// Attempt to run two PWM outputs with 180° phase shifting
// Version x.x
// Created by Wayne Chin
// October 15, 2010

#include "mbed.h"

#define TRUE 1
#define FALSE 0

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Ticker pwmramp1;
Ticker pwmramp2;
int duty1; // Duty cycle in integer %
int duty2; // Duty cycle in integer %
int PWMclock; // PWM clock = system clock / 4
int PWMrate; // Use to calculate PWM rate (period)

Serial pc(USBTX, USBRX); // tx, rx

void pwmupdate1()
{
    int PWMwidth, PWMhalf, PWMrising, PWMfalling;
    if (duty1++ > 100) duty1 = 0; // Clamp at 100% pulsewidth
    PWMwidth = (duty1 * PWMrate) / 100;
    PWMhalf = PWMwidth / 2;
    PWMrising = PWMrate - PWMhalf;
    PWMfalling = PWMhalf;
    LPC_PWM1->MR3 = PWMrising; // Set rising edge
    LPC_PWM1->MR4 = PWMfalling; // Set falling edge
    LPC_PWM1->LER |= 0x18; // Enable PWM Match 3 & 4 latch
    led4 = !led4;
}

void pwmupdate2()
{
    int PWMcenter, PWMwidth, PWMhalf, PWMrising, PWMfalling;
    if (duty2++ > 100) duty2 = 0; // Clamp at 100% pulsewidth
    PWMcenter = PWMrate / 2;
    PWMwidth = (duty2 * PWMrate) / 100;
    PWMhalf = PWMwidth / 2;
    PWMrising = PWMcenter - PWMhalf;
    PWMfalling = PWMcenter + PWMhalf;
    LPC_PWM1->MR5 = PWMrising;
    LPC_PWM1->MR6 = PWMfalling;
    LPC_PWM1->LER |= 0x60; // Enable PWM Match 5 & 6 latch
    led2 = !led2;
}

int main() 
{
    /****** Program Starts Here *******/
    pc.baud(19200);
    pc.printf("\n\rConnected to mBed...\r\n");
    // Initialize variables
    duty1 = 0;
    duty2 = 0;
    
    printf("SystemCoreClock = %d Hz\r\n", SystemCoreClock);
    // Verify power control for peripherals register
    printf("PCLKSEL0: %x\n\r", LPC_SC->PCLKSEL0);          // Leave at CCLK/4
    PWMclock = SystemCoreClock / 4;
    PWMrate = PWMclock / 15000;                            // 15kHz
    printf("PWMrate: %x\n\r", PWMrate);
    //printf("PINSEL4: %x\n\r", LPC_PINCON->PINSEL4);        // Comes up as GPIO
    LPC_PINCON->PINSEL4 |= 0x00000040;                     // Set P2.3 for PWM1.4
    LPC_PINCON->PINSEL4 |= 0x00000400;                     // Set P2.5 for PWM1.6
    printf("PINSEL4: %x\n\r", LPC_PINCON->PINSEL4);
    // Set up count control register
    printf("PWM1CTCR: %x\n\r", LPC_PWM1->CTCR); // Should already come up in timer mode
    // Set up match control register
    printf("PWM1MCR: %x\n\r", LPC_PWM1->MCR);
    //LPC_PWM1->MCR |= 0x00002000; // Reset PWM4 on match - do not use
    //LPC_PWM1->MCR |= 0x00080000; // Reset PWM6 on match - do not use
    LPC_PWM1->MCR |= 0x00000002; // Reset PWM0 on match
    printf("PWM1MCR: %x\n\r", LPC_PWM1->MCR);
    // Set up match registers
    LPC_PWM1->MR0 = PWMrate; // Set MR0 (PWM rate)
    LPC_PWM1->MR3 = 0x000; // Reset MR3
    LPC_PWM1->MR4 = 0x320; // Reset MR4
    LPC_PWM1->MR5 = 0x160; // Reset MR5
    LPC_PWM1->MR6 = 0x480; // Reset MR6
    printf("PWM1MR0,3,4,5,6: %x %x %x %x %x\n\r", LPC_PWM1->MR0, LPC_PWM1->MR3, LPC_PWM1->MR4, LPC_PWM1->MR5, LPC_PWM1->MR6);
    // Set up latch enable register
    printf("PWM1LER: %x\n\r", LPC_PWM1->LER);
    LPC_PWM1->LER |= 0x08; // Enable PWM Match 3 latch
    LPC_PWM1->LER |= 0x10; // Enable PWM Match 4 latch
    LPC_PWM1->LER |= 0x20; // Enable PWM Match 5 latch
    LPC_PWM1->LER |= 0x40; // Enable PWM Match 6 latch
    printf("PWM1LER: %x\n\r", LPC_PWM1->LER);
    // Set up PWM control register
    printf("PWM1PCR: %x\n\r", LPC_PWM1->PCR);
    LPC_PWM1->PCR |= 0x00000010; // Select double edge PWM for PWM4
    LPC_PWM1->PCR |= 0x00000040; // Select double edge PWM for PWM6
    LPC_PWM1->PCR |= 0x00001000; // Enable PWM4
    LPC_PWM1->PCR |= 0x00004000; // Enable PWM6
    printf("PWM1PCR: %x\n\r", LPC_PWM1->PCR);
    // Set up timer control register
    printf("PWM1TCR: %x\n\r", LPC_PWM1->TCR);
    LPC_PWM1->TCR |= 0x08; // Enable PWM mode
    LPC_PWM1->TCR |= 0x01; // Enable counter
    printf("PWM1TCR: %x\n\r", LPC_PWM1->TCR);

    // Set up timeout calls
    pwmramp1.attach_us(&pwmupdate1, 250000); // setup pwmramp1 to call pwmupdate after 250 ms
    pwmramp2.attach_us(&pwmupdate2, 500000); // setup pwmramp2 to call pwmupdate after 500 ms

    while (1)
    {
        
    }//while
}//main