#include "ParserTest.h"
#include <stdio.h>
#include <assert.h>
#include <ParsedRecord.h>
#include <string.h>

ParserTest::ParserTest()
{
}

void ParserTest::testAll()
{
    puts("Parser test scenario 1");
    testScenario1();
    puts("Parser test scenario 2");
    testScenario2();
    puts("Parser test scenario 3");
    testScenario3();
}

void ParserTest::testScenario1()
{
    ParsedRecord record; uint8_t res;
    char str[] = "100,Value1,Value2\r\n";

    _source.set(str);
    res = _parser.readFrom(_source, record);
    assert(res == PARSER_SUCCESS);
    assert(record);
    assert(record.values() == 3);
    assert(record.value(0).integerValue() == 100);
    assert(strcmp(record.value(1).characterValue(), "Value1") == 0);
    assert(strcmp(record.value(2).characterValue(), "Value2") == 0);

    res = _parser.readFrom(_source, record);
    assert(res == PARSER_END_OF_RESPONSE);
    assert(!record);
}

void ParserTest::testScenario2()
{
    ParsedRecord record; uint8_t res;
    char str[] = "100,Value1,Value2\r\n"
                 "200,\"Hello, Test\", hello ,5.3\r\n";

    _source.set(str);
    res = _parser.readFrom(_source, record);
    assert(res == PARSER_SUCCESS);
    assert(record);
    assert(record.values() == 3);
    assert(record.value(0).integerValue() == 100);
    assert(strcmp(record.value(1).characterValue(), "Value1") == 0);
    assert(strcmp(record.value(2).characterValue(), "Value2") == 0);

    res = _parser.readFrom(_source, record);
    assert(res == PARSER_SUCCESS);
    assert(record);
    assert(record.values() == 4);
    assert(record.value(0).integerValue() == 200);
    assert(strcmp(record.value(1).characterValue(), "Hello, Test") == 0);
    assert(strcmp(record.value(2).characterValue(), "hello") == 0);
    assert(record.value(3).floatValue() == 5.3);

    res = _parser.readFrom(_source, record);
    assert(res == PARSER_END_OF_RESPONSE);
    assert(!record);
}

void ParserTest::testScenario3()
{
    ParsedRecord record; uint8_t res;
    char str[] = "100,Val\"\"ue1,Value2\r\n";

    _source.set(str);
    res = _parser.readFrom(_source, record);
    assert(res == PARSER_PARSE_ERROR);
    assert(!record);
}

