#include "IntegerValueTest.h"
#include <stdio.h>
#include <assert.h>
#include <string.h>

IntegerValueTest::IntegerValueTest()
{
}

void IntegerValueTest::test()
{
    testValue(0, "0");
    testValue(-1, "-1");
    testValue(400, "400");
    testValue(-123456, "-123456");
    testValue(123456, "123456");
    testValue(123123123, "123123123");
}

void IntegerValueTest::testValue(long number, const char *expected)
{
    printf("Expecting '%s' for number %d\n", expected, number);
    IntegerValue value(number);
    assert(value.length() == strlen(expected));
    assert(value.valueType() == VALUE_INTEGER);
    assert(value.integerValue() == number);
    value.write(sink);
    assert(strcmp(expected, sink.value()) == 0);
    sink.clear();

    Value *copy = value.copy();
    assert(copy->length() == value.length());
    assert(copy->integerValue() == value.integerValue());
    assert(copy->valueType() == value.valueType());
    delete copy;
}

