#include "ComposedRecordTest.h"
#include "CharValue.h"
#include "IntegerValue.h"
#include "FloatValue.h"
#include <stdio.h>
#include <assert.h>
#include <string.h>

ComposedRecordTest::ComposedRecordTest()
{
}

void ComposedRecordTest::test()
{
    CharValue hello("Hello World!");
    CharValue random("RandomValue");
    CharValue test(" \", ");
    IntegerValue someNumber(12345);
    FloatValue pi(3.141, 2);

    Value *v1[2] = {&hello, &pi};
    testValue(v1, 2, "Hello World!,3.14\r\n");

    Value *v2[3] = {&someNumber, &random, &pi};
    testValue(v2, 3, "12345,RandomValue,3.14\r\n");

    Value *v3[2] = {&random,&test};
    testValue(v3, 2, "RandomValue,\" \"\", \"\r\n");
}

void ComposedRecordTest::testValue(Value **values, size_t count, const char *expected)
{
    printf("Now testing a composed record with %lu values. Expected value: %s", count, expected);
    ComposedRecord record;
    for (size_t n = 0; n < count; n++)
        record.add(*values[n]);

    assert(record.writtenLength() == strlen(expected));
    record.writeTo(sink);
    assert(strcmp(expected, sink.value()) == 0);
    sink.clear();
}

