#include "AggregatorTest.h"
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <StaticData.h>
#include <CharValue.h>
#include <IntegerValue.h>
#include <FloatValue.h>
#include <ComposedRecord.h>

AggregatorTest::AggregatorTest()
{
}

void AggregatorTest::testAll()
{
    test1();
    test2();
}

void AggregatorTest::test1()
{
    assert((_aggr.length() + _aggr.writtenLength()) == 0);

    DataGenerator *copy = NULL;
    for (size_t a = 1; a < 11; a++) {
        printf("Filling aggregator for the %dth time\n", a);

        StaticData data("This is a test.", true);
        assert(data.writtenLength() == 15);

        for (size_t n = 0; n < a*10; n++) {
            assert(_aggr.add(data));
            assert(_aggr.length() == n+1);
            if (n % 10 == 0) {
                assert(_aggr.writtenLength() == (n+1)*data.writtenLength());
            }
        }
        if (copy != NULL)
            delete copy;
        copy = _aggr.copy();
        assert(_aggr.writtenLength() == copy->writtenLength());
        _aggr.clear();
    }

    assert((_aggr.length() + _aggr.writtenLength()) == 0);

    assert(copy->writtenLength() == 1000*10*15);
    delete copy;
}

void AggregatorTest::test2()
{
    assert((_aggr.length() + _aggr.writtenLength()) == 0);

    for (size_t a = 1; a < 11; a++) {
        printf("Filling aggregator for the %dth time\n", a);

        for (size_t n = 0; n < a*10; n++) {
            CharValue v1("Test...");
            FloatValue v2(3.1459*n, 4);
            IntegerValue v3(300*n);
            ComposedRecord data;
            data.add(v1).add(v2).add(v3);

            _aggr.add(data);
            if (n % 10 == 0) {
                assert(_aggr.writtenLength() == (n+1)*data.writtenLength());
            }
        }

        size_t len = _aggr.writtenLength();
        DataGenerator *copy = _aggr.copy();
        assert(_aggr.writtenLength() == copy->writtenLength());
        _aggr.clear();
        assert(copy->writtenLength() == len);
    }
}

