#include "MockClient.h"

#define STATE_INIT 0
#define STATE_IN_REQUEST 1
#define STATE_SENT_ID 2
#define STATE_SENT_DATA 3
#define STATE_REQ_COMPLETE 4
#define STATE_RECVD_RESPONSE 5
#define STATE_RECV_DATA 6

MockClient::MockClient()
{
    _state = STATE_INIT;
    _data = NULL;
    _ident = NULL;
}

void MockClient::receiveData(const char* str)
{
    _data = str;
}

char* MockClient::sentData()
{
    return _sink.value();
}

void MockClient::clearSent()
{
    _sink.clear();
}

uint8_t MockClient::beginRequest()
{
    if (_state != STATE_INIT)
        return CLIENT_INTERNAL_ERROR;
    _state = STATE_IN_REQUEST;
    return CLIENT_OK;
}

uint8_t MockClient::sendIdentifier(const char* identifier)
{
    if (_state != STATE_IN_REQUEST)
        return CLIENT_INTERNAL_ERROR;
    _ident = (char*)identifier;
    _state = STATE_SENT_ID;
    return CLIENT_OK;
}

uint8_t MockClient::sendData(DataGenerator& generator)
{
    if (_state != STATE_SENT_ID)
        return CLIENT_INTERNAL_ERROR;
    generator.writeTo(_sink);
    _state = STATE_SENT_DATA;
    return CLIENT_OK;
}

uint8_t MockClient::endRequest()
{
    if ((_state != STATE_SENT_ID) && (_state != STATE_SENT_DATA))
        return CLIENT_INTERNAL_ERROR;
    _state = STATE_REQ_COMPLETE;
    return CLIENT_OK;
}

uint8_t MockClient::awaitResponse()
{
    if (_state != STATE_REQ_COMPLETE)
        return CLIENT_INTERNAL_ERROR;
    _state = STATE_RECVD_RESPONSE;
    return CLIENT_OK;
}

AbstractDataSource& MockClient::receiveData()
{
    if ((_state == STATE_RECVD_RESPONSE) && (_data != NULL))
        _source.set(_data);
    else
        _source.clear();
    _state = STATE_RECV_DATA;
    return _source;
}

void MockClient::stop()
{
    _state = STATE_INIT;
    _sink.clear();
    _source.clear();
}

