#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "BufferedDataSource.h"

BufferedDataSource::BufferedDataSource()
{
    clear();
}

void BufferedDataSource::set(char *buf, size_t length)
{
    _data = _ptr = buf;
    _length = length;
}

void BufferedDataSource::set(const char *str)
{
    _data = _ptr = (char *)str;
    _length = strlen(str);
}

void BufferedDataSource::clear()
{
    _data = _ptr = NULL;
    _length = 0;
}

bool BufferedDataSource::exhausted()
{
    return (_ptr - _data) == _length;
}

char BufferedDataSource::read()
{
    if (exhausted())
        return 0;
    return *_ptr++;
}

uint8_t BufferedDataSource::status()
{
    if (exhausted())
        return DS_STATUS_CLOSED;
    return DS_STATUS_OK;
}

