#ifndef BUFFEREDDATASINK_H
#define BUFFEREDDATASINK_H

#include <stddef.h>
#include <AbstractDataSink.h>

// the minimal free memory
#define BDS_MIN_FREE_MEMORY 25
// the initial memory and memory increment
#define BDS_MEMORY_INCREMENT 128

class BufferedDataSink : public AbstractDataSink
{
public:
    BufferedDataSink();
    ~BufferedDataSink();

    char * value();
    void clear();

    size_t write(char c);
    size_t write(void *buf, size_t length);
    size_t write(const char *str);
    size_t write(unsigned long number);

protected:
    void ensureMinimumFreeMemory(size_t required);

private:
    char *_buffer, *_ptr;
    size_t _size;
};

#endif
